/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions;

import org.eclipse.core.expressions.AndExpression;
import org.eclipse.core.expressions.CompositeExpression;
import org.eclipse.core.expressions.CountExpression;
import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.EqualsExpression;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.OrExpression;
import org.eclipse.core.expressions.ReferenceExpression;
import org.eclipse.core.expressions.TestExpression;
import org.eclipse.core.expressions.WithExpression;
import org.eclipse.core.internal.expressions.AdaptExpression;
import org.eclipse.core.internal.expressions.EnablementExpression;
import org.eclipse.core.internal.expressions.InstanceofExpression;
import org.eclipse.core.internal.expressions.IterateExpression;
import org.eclipse.core.internal.expressions.NotExpression;
import org.eclipse.core.internal.expressions.ResolveExpression;
import org.eclipse.core.internal.expressions.SystemTestExpression;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StandardElementHandler
extends ElementHandler {
    @Override
    public Expression create(ExpressionConverter converter, IConfigurationElement element) throws CoreException {
        String name = element.getName();
        if (name == null) {
            return null;
        }
        switch (name) {
            case "instanceof": {
                return new InstanceofExpression(element);
            }
            case "test": {
                return new TestExpression(element);
            }
            case "or": {
                OrExpression result = new OrExpression();
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "and": {
                AndExpression result = new AndExpression();
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "not": {
                return new NotExpression(converter.perform(element.getChildren()[0]));
            }
            case "with": {
                WithExpression result = new WithExpression(element);
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "adapt": {
                AdaptExpression result = new AdaptExpression(element);
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "iterate": {
                IterateExpression result = new IterateExpression(element);
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "count": {
                return new CountExpression(element);
            }
            case "systemTest": {
                return new SystemTestExpression(element);
            }
            case "resolve": {
                ResolveExpression result = new ResolveExpression(element);
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "enablement": {
                EnablementExpression result = new EnablementExpression(element);
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "equals": {
                return new EqualsExpression(element);
            }
            case "reference": {
                return new ReferenceExpression(element);
            }
        }
        return null;
    }

    @Override
    public Expression create(ExpressionConverter converter, Element element) throws CoreException {
        String name = element.getNodeName();
        if (name == null) {
            return null;
        }
        switch (name) {
            case "instanceof": {
                return new InstanceofExpression(element);
            }
            case "test": {
                return new TestExpression(element);
            }
            case "or": {
                OrExpression result = new OrExpression();
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "and": {
                AndExpression result = new AndExpression();
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "not": {
                Node child = element.getFirstChild();
                while (child != null) {
                    if (child.getNodeType() == 1) {
                        return new NotExpression(converter.perform((Element)child));
                    }
                    child = child.getNextSibling();
                }
                break;
            }
            case "with": {
                WithExpression result = new WithExpression(element);
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "adapt": {
                AdaptExpression result = new AdaptExpression(element);
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "iterate": {
                IterateExpression result = new IterateExpression(element);
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "count": {
                return new CountExpression(element);
            }
            case "systemTest": {
                return new SystemTestExpression(element);
            }
            case "resolve": {
                ResolveExpression result = new ResolveExpression(element);
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "enablement": {
                EnablementExpression result = new EnablementExpression(element);
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "equals": {
                return new EqualsExpression(element);
            }
            case "reference": {
                return new ReferenceExpression(element);
            }
        }
        return null;
    }
}

