/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions;

import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.Messages;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.util.NLS;

public class MarkStartedAction
extends ProvisioningAction {
    public static final String ID = "markStarted";

    public IStatus execute(Map<String, Object> parameters) {
        Manipulator manipulator = (Manipulator)parameters.get("manipulator");
        IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
        String started = (String)parameters.get("started");
        if (started == null) {
            return Util.createError(NLS.bind((String)Messages.parameter_not_set, (Object)"started", (Object)ID));
        }
        BundleInfo bundleInfo = Util.findBundleInfo(manipulator.getConfigData(), iu);
        if (bundleInfo == null) {
            return Util.createWarning(NLS.bind((String)Messages.failed_find_bundleinfo, (Object)iu));
        }
        if (bundleInfo.getFragmentHost() != null) {
            return Status.OK_STATUS;
        }
        this.getMemento().put("previousStarted", (Object)bundleInfo.isMarkedAsStarted());
        bundleInfo.setMarkedAsStarted(Boolean.valueOf(started).booleanValue());
        return Status.OK_STATUS;
    }

    public IStatus undo(Map<String, Object> parameters) {
        Boolean previousStarted = (Boolean)this.getMemento().get("previousStarted");
        if (previousStarted == null) {
            return Status.OK_STATUS;
        }
        Manipulator manipulator = (Manipulator)parameters.get("manipulator");
        IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
        BundleInfo bundleInfo = Util.findBundleInfo(manipulator.getConfigData(), iu);
        if (bundleInfo == null) {
            return Util.createWarning(NLS.bind((String)Messages.failed_find_bundleinfo, (Object)iu));
        }
        bundleInfo.setMarkedAsStarted(previousStarted.booleanValue());
        return Status.OK_STATUS;
    }
}

