/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.TreeSet;

public final class Util {
    public static final SortedSet<?> EMPTY_SORTED_SET = Collections.unmodifiableSortedSet(new TreeSet());
    public static final String ZERO_LENGTH_STRING = "";

    public static void assertInstance(Object object, Class<?> c) {
        Util.assertInstance(object, c, false);
    }

    private static void assertInstance(Object object, Class<?> c, boolean allowNull) {
        if (object == null && allowNull) {
            return;
        }
        if (object == null || c == null) {
            throw new NullPointerException();
        }
        if (!c.isInstance(object)) {
            throw new IllegalArgumentException();
        }
    }

    public static int compare(boolean left, boolean right) {
        return !left ? (right ? -1 : 0) : 1;
    }

    public static int compare(int left, int right) {
        return left - right;
    }

    public static <T extends Comparable<T>> int compare(T left, T right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        return left.compareTo(right);
    }

    public static <T extends Comparable<T>> int compare(T[] left, T[] right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        int l = left.length;
        int r = right.length;
        if (l != r) {
            return l - r;
        }
        int i = 0;
        while (i < l) {
            int compareTo = Util.compare(left[i], right[i]);
            if (compareTo != 0) {
                return compareTo;
            }
            ++i;
        }
        return 0;
    }

    public static <T extends Comparable<T>> int compare(List<T> left, List<T> right) {
        int r;
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        int l = left.size();
        if (l != (r = right.size())) {
            return l - r;
        }
        int i = 0;
        while (i < l) {
            int compareTo = Util.compare((Comparable)left.get(i), (Comparable)right.get(i));
            if (compareTo != 0) {
                return compareTo;
            }
            ++i;
        }
        return 0;
    }

    public static boolean endsWith(Object[] left, Object[] right, boolean equals) {
        if (left == null || right == null) {
            return false;
        }
        int r = right.length;
        int l = left.length;
        if (r > l || !equals && r == l) {
            return false;
        }
        int i = 0;
        while (i < r) {
            if (!Objects.equals(left[l - i - 1], right[r - i - 1])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean startsWith(Object[] left, Object[] right, boolean equals) {
        if (left == null || right == null) {
            return false;
        }
        int r = right.length;
        int l = left.length;
        if (r > l || !equals && r == l) {
            return false;
        }
        int i = 0;
        while (i < r) {
            if (!Objects.equals(left[i], right[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String toString(Object[] array) {
        if (array == null) {
            return "null";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('[');
        int length = array.length;
        int i = 0;
        while (i < length) {
            if (i != 0) {
                buffer.append(',');
            }
            Object object = array[i];
            String element = String.valueOf(object);
            buffer.append(element);
            ++i;
        }
        buffer.append(']');
        return buffer.toString();
    }

    public static String translateString(ResourceBundle resourceBundle, String key, String defaultString) {
        if (resourceBundle != null && key != null) {
            try {
                String translatedString = resourceBundle.getString(key);
                if (translatedString != null) {
                    return translatedString;
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return defaultString;
    }

    public static String replaceAll(String src, String find, String replacement) {
        int len = src.length();
        int findLen = find.length();
        int idx = src.indexOf(find);
        if (idx < 0) {
            return src;
        }
        StringBuilder buf = new StringBuilder();
        int beginIndex = 0;
        while (idx != -1 && idx < len) {
            buf.append(src.substring(beginIndex, idx));
            buf.append(replacement);
            beginIndex = idx + findLen;
            idx = beginIndex < len ? src.indexOf(find, beginIndex) : -1;
        }
        if (beginIndex < len) {
            buf.append(src.substring(beginIndex, idx == -1 ? len : idx));
        }
        return buf.toString();
    }

    private Util() {
    }
}

