/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess.providers;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.commands.ExpressionContext;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;
import org.eclipse.ui.internal.quickaccess.providers.CommandElement;
import org.eclipse.ui.quickaccess.QuickAccessElement;

public class CommandProvider
extends QuickAccessProvider {
    private IEclipseContext context;
    private ExpressionContext evaluationContext;
    private final Map<String, CommandElement> idToCommand = Collections.synchronizedMap(new HashMap());
    private IHandlerService handlerService;
    private ICommandService commandService;
    private EHandlerService ehandlerService;
    private ICommandImageService commandImageService;
    private boolean allCommandsRetrieved;
    Map<String, String> idToFqn = Collections.synchronizedMap(new HashMap());

    public void setContext(IEclipseContext context) {
        this.reset();
        this.context = context;
        this.evaluationContext = new ExpressionContext(context);
    }

    @Override
    public String getId() {
        return "org.eclipse.ui.commands";
    }

    @Override
    public QuickAccessElement findElement(String id, String filterText) {
        this.retrieveCommand(id);
        return this.idToCommand.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QuickAccessElement[] getElements() {
        if (!this.allCommandsRetrieved) {
            ICommandService commandService = this.getCommandService();
            if (commandService == null) {
                return null;
            }
            if (this.idToFqn.isEmpty()) {
                this.parseWorkbenchCommands();
            }
            Collection commandIds = commandService.getDefinedCommandIds();
            for (String commandId : commandIds) {
                this.retrieveCommand(commandId);
            }
            this.allCommandsRetrieved = true;
        }
        Map<String, CommandElement> map = this.idToCommand;
        synchronized (map) {
            return (QuickAccessElement[])this.idToCommand.values().stream().toArray(QuickAccessElement[]::new);
        }
    }

    private void parseWorkbenchCommands() {
        IExtension[] extensions;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.ui.commands");
        IExtension[] iExtensionArray = extensions = point.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if ("command".equals(element.getName())) {
                    String id = element.getAttribute("id");
                    String qualifiedName = element.getContributor().getName() + "/" + id;
                    this.idToFqn.put(id, qualifiedName);
                }
                ++n4;
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveCommand(String currentCommandId) {
        boolean commandRetrieved = this.idToCommand.containsKey(currentCommandId);
        if (!commandRetrieved) {
            ICommandService commandService = this.getCommandService();
            EHandlerService ehandlerService = this.getEHandlerService();
            Command command = commandService.getCommand(currentCommandId);
            ParameterizedCommand pcmd = new ParameterizedCommand(command, null);
            if (command != null && ehandlerService.canExecute(pcmd, this.context)) {
                try {
                    Collection combinations = ParameterizedCommand.generateCombinations((Command)command);
                    for (ParameterizedCommand pc : combinations) {
                        if (this.excludeWithActivitySupport(pc)) continue;
                        String id = pc.serialize();
                        Map<String, CommandElement> map = this.idToCommand;
                        synchronized (map) {
                            this.idToCommand.put(id, new CommandElement(pc, id, this));
                        }
                    }
                }
                catch (NotDefinedException notDefinedException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean excludeWithActivitySupport(ParameterizedCommand pc) {
        if (!WorkbenchActivityHelper.isFiltering()) {
            return false;
        }
        String commandId = this.getQualifiedCommandId(pc.getCommand());
        if (commandId == null) {
            return false;
        }
        IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
        IIdentifier identifier = workbenchActivitySupport.getActivityManager().getIdentifier(commandId);
        return !identifier.isEnabled();
    }

    private String getQualifiedCommandId(Command command) {
        String cmdId = command.getId();
        if (cmdId.startsWith("AUTOGEN:::")) {
            return cmdId.substring("AUTOGEN:::".length());
        }
        return this.idToFqn.get(cmdId);
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return WorkbenchImages.getImageDescriptor("IMG_OBJ_NODE");
    }

    @Override
    public String getName() {
        return QuickAccessMessages.QuickAccess_Commands;
    }

    EHandlerService getEHandlerService() {
        if (this.ehandlerService == null) {
            this.ehandlerService = this.context != null ? (EHandlerService)this.context.get(EHandlerService.class) : (EHandlerService)PlatformUI.getWorkbench().getService(EHandlerService.class);
        }
        return this.ehandlerService;
    }

    ICommandService getCommandService() {
        if (this.commandService == null) {
            this.commandService = this.context != null ? (ICommandService)this.context.get(ICommandService.class) : (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        }
        return this.commandService;
    }

    IHandlerService getHandlerService() {
        if (this.handlerService == null) {
            this.handlerService = this.context != null ? (IHandlerService)this.context.get(IHandlerService.class) : (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        }
        return this.handlerService;
    }

    public ICommandImageService getCommandImageService() {
        if (this.commandImageService == null) {
            this.commandImageService = this.context != null ? (ICommandImageService)this.context.get(ICommandImageService.class) : (ICommandImageService)PlatformUI.getWorkbench().getService(ICommandImageService.class);
        }
        return this.commandImageService;
    }

    public IEvaluationContext getEvaluationContext() {
        return this.evaluationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doReset() {
        this.allCommandsRetrieved = false;
        Map<String, CommandElement> map = this.idToCommand;
        synchronized (map) {
            this.idToCommand.clear();
        }
        this.evaluationContext = null;
        this.context = null;
    }

    @Override
    public boolean requiresUiAccess() {
        return true;
    }
}

