/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers.deferred;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.deferred.AbstractConcurrentModel;
import org.eclipse.jface.viewers.deferred.IConcurrentModelListener;

public class SetModel
extends AbstractConcurrentModel {
    private final HashSet data = new HashSet();

    public Object[] getElements() {
        return this.data.toArray();
    }

    public void set(Object[] newContents) {
        IConcurrentModelListener[] listeners;
        Assert.isNotNull((Object)newContents);
        this.data.clear();
        this.data.addAll(Arrays.asList(newContents));
        IConcurrentModelListener[] iConcurrentModelListenerArray = listeners = this.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IConcurrentModelListener listener = iConcurrentModelListenerArray[n2];
            listener.setContents(newContents);
            ++n2;
        }
    }

    public void clear() {
        Object[] removed = this.data.toArray();
        this.data.clear();
        this.fireRemove(removed);
    }

    public void addAll(Object[] toAdd) {
        Assert.isNotNull((Object)toAdd);
        this.data.addAll(Arrays.asList(toAdd));
        this.fireAdd(toAdd);
    }

    public void addAll(Collection toAdd) {
        Assert.isNotNull((Object)toAdd);
        this.addAll(toAdd.toArray());
    }

    public void changeAll(Object[] changed) {
        Assert.isNotNull((Object)changed);
        this.fireUpdate(changed);
    }

    public void removeAll(Object[] toRemove) {
        Assert.isNotNull((Object)toRemove);
        Object[] objectArray = toRemove;
        int n = toRemove.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            this.data.remove(object);
            ++n2;
        }
        this.fireRemove(toRemove);
    }

    @Override
    public void requestUpdate(IConcurrentModelListener listener) {
        Assert.isNotNull((Object)listener);
        listener.setContents(this.getElements());
    }
}

