/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.SWTFontProvider;
import org.eclipse.swt.internal.Win32DPIUtils;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.PointF;
import org.eclipse.swt.internal.gdip.RectF;
import org.eclipse.swt.internal.win32.OS;

public class Path
extends Resource {
    private Map<Integer, PathHandle> zoomToHandle = new HashMap<Integer, PathHandle>();
    private List<Operation> operations = new ArrayList<Operation>();
    private boolean isDestroyed;

    public Path(Device device) {
        super(device);
        this.device.checkGDIP();
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    public Path(Device device, Path path, float flatness) {
        super(device);
        if (path == null) {
            SWT.error(4);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
        flatness = Math.max(0.0f, flatness);
        path.operations.forEach(this::storeAndApplyOperationOnAllHandles);
        if (flatness != 0.0f) {
            this.storeAndApplyOperationOnAllHandles(new FlattenOperation(flatness));
        }
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    public Path(Device device, PathData data) {
        this(device);
        if (data == null) {
            SWT.error(4);
        }
        this.init(data);
    }

    public void addArc(float x, float y, float width, float height, float startAngle, float arcAngle) {
        if (width == 0.0f || height == 0.0f || arcAngle == 0.0f) {
            return;
        }
        this.storeAndApplyOperationOnAllHandles(new AddArcOperation(x, y, width, height, startAngle, arcAngle));
    }

    public void addPath(Path path) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
        this.storeAndApplyOperationOnAllHandles(new AddPathOperation(path));
    }

    public void addRectangle(float x, float y, float width, float height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.storeAndApplyOperationOnAllHandles(new AddRectangleOperation(x, y, width, height));
    }

    public void addString(String string, float x, float y, Font font) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (font == null) {
            SWT.error(4);
        }
        if (font.isDisposed()) {
            SWT.error(5);
        }
        this.storeAndApplyOperationOnAllHandles(new AddStringOperation(string, x, y, font));
    }

    public void close() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.storeAndApplyOperationOnAllHandles(new CloseOperation());
    }

    public boolean contains(float x, float y, GC gc, boolean outline) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (gc == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        return this.applyUsingAnyHandle(handle -> handle.contains(x, y, gc, outline));
    }

    public void cubicTo(float cx1, float cy1, float cx2, float cy2, float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.storeAndApplyOperationOnAllHandles(new CubicToOperation(cx1, cy1, cx2, cy2, x, y));
    }

    @Override
    void destroy() {
        this.device.deregisterResourceWithZoomSupport(this);
        this.zoomToHandle.values().forEach(PathHandle::destroy);
        this.zoomToHandle.clear();
        this.isDestroyed = true;
    }

    @Override
    void destroyHandlesExcept(Set<Integer> zoomLevels) {
        this.zoomToHandle.entrySet().removeIf(entry -> {
            Integer zoom = (Integer)entry.getKey();
            if (!zoomLevels.contains(zoom)) {
                ((PathHandle)entry.getValue()).destroy();
                return true;
            }
            return false;
        });
    }

    public void getBounds(float[] bounds) {
        if (bounds == null) {
            SWT.error(4);
        }
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (bounds.length < 4) {
            SWT.error(5);
        }
        this.applyUsingAnyHandle(handle -> {
            handle.fillBounds(bounds);
            return true;
        });
    }

    public void getCurrentPoint(float[] point) {
        if (point == null) {
            SWT.error(4);
        }
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (point.length < 2) {
            SWT.error(5);
        }
        this.applyUsingAnyHandle(handle -> {
            handle.fillCurrentPoint(point);
            return true;
        });
    }

    public PathData getPathData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.applyUsingAnyHandle(handle -> handle.getPathData());
    }

    public void lineTo(float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.storeAndApplyOperationOnAllHandles(new LineToOperation(x, y));
    }

    void init(PathData data) {
        byte[] types = data.types;
        float[] points = data.points;
        int i = 0;
        int j = 0;
        while (i < types.length) {
            switch (types[i]) {
                case 1: {
                    this.moveTo(points[j++], points[j++]);
                    break;
                }
                case 2: {
                    this.lineTo(points[j++], points[j++]);
                    break;
                }
                case 4: {
                    this.cubicTo(points[j++], points[j++], points[j++], points[j++], points[j++], points[j++]);
                    break;
                }
                case 3: {
                    this.quadTo(points[j++], points[j++], points[j++], points[j++]);
                    break;
                }
                case 5: {
                    this.close();
                    break;
                }
                default: {
                    this.dispose();
                    SWT.error(5);
                }
            }
            ++i;
        }
    }

    @Override
    public boolean isDisposed() {
        return this.isDestroyed;
    }

    public void moveTo(float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.storeAndApplyOperationOnAllHandles(new MoveToOperation(x, y));
    }

    public void quadTo(float cx, float cy, float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.storeAndApplyOperationOnAllHandles(new QuadToOperation(cx, cy, x, y));
    }

    private void storeAndApplyOperationOnAllHandles(Operation operation) {
        this.operations.add(operation);
        this.zoomToHandle.values().forEach(operation::apply);
    }

    private <T> T applyUsingAnyHandle(Function<PathHandle, T> function) {
        if (this.zoomToHandle.isEmpty()) {
            return Path.applyOnTemporaryHandle(this.getDevice(), DPIUtil.getDeviceZoom(), this.operations, function);
        }
        return function.apply(this.zoomToHandle.values().iterator().next());
    }

    private static <T> T applyOnTemporaryHandle(Device device, int zoom, List<Operation> operations, Function<PathHandle, T> function) {
        PathHandle temporaryHandle = Path.newEmptyPathHandle(device, zoom);
        try {
            for (Operation operation : operations) {
                operation.apply(temporaryHandle);
            }
            T t = function.apply(temporaryHandle);
            return t;
        }
        finally {
            temporaryHandle.destroy();
        }
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Path {*DISPOSED*}";
        }
        return "Path " + String.valueOf(this.zoomToHandle);
    }

    private static PathHandle newEmptyPathHandle(Device device, int zoom) {
        long newHandle = Gdip.GraphicsPath_new(0);
        if (newHandle == 0L) {
            SWT.error(2);
        }
        PathHandle newPathHandle = new PathHandle(device, newHandle, zoom);
        return newPathHandle;
    }

    private PathHandle newPathHandle(int zoom) {
        PathHandle newPathHandle = Path.newEmptyPathHandle(this.getDevice(), zoom);
        for (Operation operation : this.operations) {
            operation.apply(newPathHandle);
        }
        return newPathHandle;
    }

    private PathHandle getPathHandle(int zoom) {
        if (!this.zoomToHandle.containsKey(zoom)) {
            PathHandle newHandle = this.newPathHandle(zoom);
            this.zoomToHandle.put(zoom, newHandle);
            return newHandle;
        }
        return this.zoomToHandle.get(zoom);
    }

    long getHandle(int zoom) {
        return this.getPathHandle((int)zoom).handle;
    }

    private class AddArcOperation
    implements Operation {
        private final float x;
        private final float y;
        private final float width;
        private final float height;
        private final float startAngle;
        private final float arcAngle;

        public AddArcOperation(float x, float y, float width, float height, float startAngle, float arcAngle) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.startAngle = startAngle;
            this.arcAngle = arcAngle;
        }

        @Override
        public void apply(PathHandle pathHandle) {
            if (this.width == 0.0f || this.height == 0.0f || this.arcAngle == 0.0f) {
                return;
            }
            int zoom = pathHandle.zoom;
            Device drawable = Path.this.getDevice();
            float xInPixels = Win32DPIUtils.pointToPixel((Drawable)drawable, this.x, zoom);
            float yInPixels = Win32DPIUtils.pointToPixel((Drawable)drawable, this.y, zoom);
            float widthInPixels = Win32DPIUtils.pointToPixel((Drawable)drawable, this.width, zoom);
            float heightInPixels = Win32DPIUtils.pointToPixel((Drawable)drawable, this.height, zoom);
            this.addArcInPixels(pathHandle, xInPixels, yInPixels, widthInPixels, heightInPixels, this.startAngle, this.arcAngle);
        }

        private void addArcInPixels(PathHandle pathHandle, float x, float y, float width, float height, float startAngle, float arcAngle) {
            PointF currentPoint = pathHandle.currentPoint;
            long handle = pathHandle.handle;
            if (width < 0.0f) {
                x += width;
                width = -width;
            }
            if (height < 0.0f) {
                y += height;
                height = -height;
            }
            if (width == height) {
                Gdip.GraphicsPath_AddArc(handle, x, y, width, height, -startAngle, -arcAngle);
            } else {
                long matrix;
                long path = Gdip.GraphicsPath_new(0);
                if (path == 0L) {
                    SWT.error(2);
                }
                if ((matrix = Gdip.Matrix_new(width, 0.0f, 0.0f, height, x, y)) == 0L) {
                    SWT.error(2);
                }
                Gdip.GraphicsPath_AddArc(path, 0.0f, 0.0f, 1.0f, 1.0f, -startAngle, -arcAngle);
                Gdip.GraphicsPath_Transform(path, matrix);
                Gdip.GraphicsPath_AddPath(handle, path, true);
                Gdip.Matrix_delete(matrix);
                Gdip.GraphicsPath_delete(path);
            }
            Gdip.GraphicsPath_GetLastPoint(handle, currentPoint);
        }
    }

    private class AddPathOperation
    implements Operation {
        private final List<Operation> pathOperations;

        public AddPathOperation(Path path2) {
            this.pathOperations = path2.operations;
        }

        @Override
        public void apply(PathHandle pathHandle) {
            Path.applyOnTemporaryHandle(Path.this.getDevice(), pathHandle.zoom, this.pathOperations, temporaryHandle -> {
                Gdip.GraphicsPath_AddPath(pathHandle.handle, temporaryHandle.handle, false);
                pathHandle.currentPoint.X = temporaryHandle.currentPoint.X;
                pathHandle.currentPoint.Y = temporaryHandle.currentPoint.Y;
                return true;
            });
        }
    }

    private class AddRectangleOperation
    implements Operation {
        private final float x;
        private final float y;
        private final float width;
        private final float height;

        public AddRectangleOperation(float x, float y, float width, float height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        @Override
        public void apply(PathHandle pathHandle) {
            int zoom = pathHandle.zoom;
            Device drawable = Path.this.getDevice();
            float xInPixels = Win32DPIUtils.pointToPixel((Drawable)drawable, this.x, zoom);
            float yInPixels = Win32DPIUtils.pointToPixel((Drawable)drawable, this.y, zoom);
            float widthInPixels = Win32DPIUtils.pointToPixel((Drawable)drawable, this.width, zoom);
            float heightInPixels = Win32DPIUtils.pointToPixel((Drawable)drawable, this.height, zoom);
            this.addRectangleInPixels(pathHandle, xInPixels, yInPixels, widthInPixels, heightInPixels);
        }

        private void addRectangleInPixels(PathHandle pathHandle, float x, float y, float width, float height) {
            PointF currentPoint = pathHandle.currentPoint;
            long handle = pathHandle.handle;
            RectF rect = new RectF();
            rect.X = x;
            rect.Y = y;
            rect.Width = width;
            rect.Height = height;
            Gdip.GraphicsPath_AddRectangle(handle, rect);
            currentPoint.X = x;
            currentPoint.Y = y;
        }
    }

    private class AddStringOperation
    implements Operation {
        private final String string;
        private final float x;
        private final float y;
        private final FontData fontData;

        public AddStringOperation(String string, float x, float y, Font font) {
            this.string = string;
            this.x = x;
            this.y = y;
            this.fontData = font.getFontData()[0];
        }

        @Override
        public void apply(PathHandle pathHandle) {
            int zoom = pathHandle.zoom;
            Device drawable = Path.this.getDevice();
            float xInPixels = Win32DPIUtils.pointToPixel((Drawable)drawable, this.x, zoom);
            float yInPixels = Win32DPIUtils.pointToPixel((Drawable)drawable, this.y, zoom);
            this.addStringInPixels(pathHandle, xInPixels, yInPixels);
        }

        private void addStringInPixels(PathHandle pathHandle, float x, float y) {
            int zoom = pathHandle.zoom;
            PointF currentPoint = pathHandle.currentPoint;
            long handle = pathHandle.handle;
            char[] buffer = this.string.toCharArray();
            long hDC = Path.this.device.internal_new_GC(null);
            long[] family = new long[1];
            long gdipFont = GC.createGdipFont(hDC, SWTFontProvider.getFontHandle(Path.this.device, this.fontData, zoom), 0L, Path.this.device.fontCollection, family, null);
            PointF point = new PointF();
            point.X = x - Gdip.Font_GetSize(gdipFont) / 6.0f;
            point.Y = y;
            int style = Gdip.Font_GetStyle(gdipFont);
            float size = Gdip.Font_GetSize(gdipFont);
            Gdip.GraphicsPath_AddString(handle, buffer, buffer.length, family[0], style, size, point, 0L);
            Gdip.GraphicsPath_GetLastPoint(handle, currentPoint);
            Gdip.FontFamily_delete(family[0]);
            Gdip.Font_delete(gdipFont);
            Path.this.device.internal_dispose_GC(hDC, null);
        }
    }

    private record CloseOperation() implements Operation
    {
        @Override
        public void apply(PathHandle pathHandle) {
            PointF startPoint = pathHandle.startPoint;
            PointF currentPoint = pathHandle.currentPoint;
            long handle = pathHandle.handle;
            Gdip.GraphicsPath_CloseFigure(handle);
            currentPoint.X = startPoint.X;
            currentPoint.Y = startPoint.Y;
        }
    }

    private class CubicToOperation
    implements Operation {
        private final float cx1;
        private final float cy1;
        private final float cx2;
        private final float cy2;
        private final float x;
        private final float y;

        public CubicToOperation(float cx1, float cy1, float cx2, float cy2, float x, float y) {
            this.cx1 = cx1;
            this.cy1 = cy1;
            this.cx2 = cx2;
            this.cy2 = cy2;
            this.x = x;
            this.y = y;
        }

        @Override
        public void apply(PathHandle pathHandle) {
            int zoom = pathHandle.zoom;
            Device drawable = Path.this.getDevice();
            float cx1InPixels = Win32DPIUtils.pointToPixel((Drawable)drawable, this.cx1, zoom);
            float cy1InPixels = Win32DPIUtils.pointToPixel((Drawable)drawable, this.cy1, zoom);
            float cx2InPixels = Win32DPIUtils.pointToPixel((Drawable)drawable, this.cx2, zoom);
            float cy2InPixels = Win32DPIUtils.pointToPixel((Drawable)drawable, this.cy2, zoom);
            float xInPixels = Win32DPIUtils.pointToPixel((Drawable)drawable, this.x, zoom);
            float yInPixels = Win32DPIUtils.pointToPixel((Drawable)drawable, this.y, zoom);
            this.cubicToInPixels(pathHandle, cx1InPixels, cy1InPixels, cx2InPixels, cy2InPixels, xInPixels, yInPixels);
        }

        private void cubicToInPixels(PathHandle pathHandle, float cx1, float cy1, float cx2, float cy2, float x, float y) {
            PointF currentPoint = pathHandle.currentPoint;
            long handle = pathHandle.handle;
            Gdip.GraphicsPath_AddBezier(handle, currentPoint.X, currentPoint.Y, cx1, cy1, cx2, cy2, x, y);
            Gdip.GraphicsPath_GetLastPoint(handle, currentPoint);
        }
    }

    private record FlattenOperation(float flatness) implements Operation
    {
        @Override
        public void apply(PathHandle pathHandle) {
            long handle = pathHandle.handle;
            Gdip.GraphicsPath_Flatten(handle, 0L, this.flatness);
        }
    }

    private class LineToOperation
    implements Operation {
        private final float x;
        private final float y;

        public LineToOperation(float x, float y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public void apply(PathHandle pathHandle) {
            int zoom = pathHandle.zoom;
            Device drawable = Path.this.getDevice();
            this.lineToInPixels(pathHandle, Win32DPIUtils.pointToPixel((Drawable)drawable, this.x, zoom), Win32DPIUtils.pointToPixel((Drawable)drawable, this.y, zoom));
        }

        private void lineToInPixels(PathHandle pathHandle, float x, float y) {
            PointF currentPoint = pathHandle.currentPoint;
            long handle = pathHandle.handle;
            Gdip.GraphicsPath_AddLine(handle, currentPoint.X, currentPoint.Y, x, y);
            Gdip.GraphicsPath_GetLastPoint(handle, currentPoint);
        }
    }

    private class MoveToOperation
    implements Operation {
        private final float x;
        private final float y;

        public MoveToOperation(float x, float y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public void apply(PathHandle pathHandle) {
            int zoom = pathHandle.zoom;
            Device drawable = Path.this.getDevice();
            this.moveToInPixels(pathHandle, Win32DPIUtils.pointToPixel((Drawable)drawable, this.x, zoom), Win32DPIUtils.pointToPixel((Drawable)drawable, this.y, zoom));
        }

        void moveToInPixels(PathHandle pathHandle, float x, float y) {
            PointF startPoint = pathHandle.startPoint;
            PointF currentPoint = pathHandle.currentPoint;
            long handle = pathHandle.handle;
            Gdip.GraphicsPath_StartFigure(handle);
            currentPoint.X = startPoint.X = x;
            currentPoint.Y = startPoint.Y = y;
        }
    }

    private static interface Operation {
        public void apply(PathHandle var1);
    }

    private static class PathHandle {
        private final Device device;
        private final long handle;
        private final int zoom;
        private PointF currentPoint = new PointF();
        private PointF startPoint = new PointF();

        public PathHandle(Device device, long handle, int zoom) {
            this.device = device;
            this.handle = handle;
            this.zoom = zoom;
        }

        boolean contains(float x, float y, GC gc, boolean outline) {
            float xInPixels = Win32DPIUtils.pointToPixel((Drawable)this.device, x, this.zoom);
            float yInPixels = Win32DPIUtils.pointToPixel((Drawable)this.device, y, this.zoom);
            return this.containsInPixels(xInPixels, yInPixels, gc, outline);
        }

        private boolean containsInPixels(float x, float y, GC gc, boolean outline) {
            gc.initGdip();
            gc.checkGC(120);
            int mode = OS.GetPolyFillMode(gc.handle) == 2 ? 1 : 0;
            Gdip.GraphicsPath_SetFillMode(this.handle, mode);
            if (outline) {
                return Gdip.GraphicsPath_IsOutlineVisible(this.handle, x, y, gc.data.gdipPen, gc.data.gdipGraphics);
            }
            return Gdip.GraphicsPath_IsVisible(this.handle, x, y, gc.data.gdipGraphics);
        }

        void destroy() {
            Gdip.GraphicsPath_delete(this.handle);
        }

        void fillBounds(float[] bounds) {
            this.getBoundsInPixels(bounds);
            float[] scaledbounds = Win32DPIUtils.pixelToPoint((Drawable)this.device, bounds, this.zoom);
            System.arraycopy(scaledbounds, 0, bounds, 0, 4);
        }

        private void getBoundsInPixels(float[] bounds) {
            RectF rect = new RectF();
            Gdip.GraphicsPath_GetBounds(this.handle, rect, 0L, 0L);
            bounds[0] = rect.X;
            bounds[1] = rect.Y;
            bounds[2] = rect.Width;
            bounds[3] = rect.Height;
        }

        void fillCurrentPoint(float[] point) {
            this.getCurrentPointInPixels(point);
            float[] scaledpoint = Win32DPIUtils.pixelToPoint((Drawable)this.device, point, this.zoom);
            System.arraycopy(scaledpoint, 0, point, 0, 2);
        }

        private void getCurrentPointInPixels(float[] point) {
            point[0] = this.currentPoint.X;
            point[1] = this.currentPoint.Y;
        }

        PathData getPathData() {
            PathData result = this.getPathDataInPixels();
            result.points = Win32DPIUtils.pixelToPoint((Drawable)this.device, result.points, this.zoom);
            return result;
        }

        private PathData getPathDataInPixels() {
            int count = Gdip.GraphicsPath_GetPointCount(this.handle);
            byte[] gdipTypes = new byte[count];
            float[] points = new float[count * 2];
            Gdip.GraphicsPath_GetPathTypes(this.handle, gdipTypes, count);
            Gdip.GraphicsPath_GetPathPoints(this.handle, points, count);
            byte[] types = new byte[count * 2];
            int index = 0;
            int typesIndex = 0;
            while (index < count) {
                byte type = gdipTypes[index];
                boolean close = false;
                switch (type & 7) {
                    case 0: {
                        types[typesIndex++] = 1;
                        close = (type & 0x80) != 0;
                        ++index;
                        break;
                    }
                    case 1: {
                        types[typesIndex++] = 2;
                        close = (type & 0x80) != 0;
                        ++index;
                        break;
                    }
                    case 3: {
                        types[typesIndex++] = 4;
                        close = (gdipTypes[index + 2] & 0x80) != 0;
                        index += 3;
                        break;
                    }
                    default: {
                        ++index;
                    }
                }
                if (!close) continue;
                types[typesIndex++] = 5;
            }
            if (typesIndex != types.length) {
                byte[] newTypes = new byte[typesIndex];
                System.arraycopy(types, 0, newTypes, 0, typesIndex);
                types = newTypes;
            }
            PathData result = new PathData();
            result.types = types;
            result.points = points;
            return result;
        }

        public String toString() {
            return "PathHandle [handle=" + this.handle + ", zoom=" + this.zoom + "]";
        }

        static /* synthetic */ long access$0(PathHandle pathHandle) {
            return pathHandle.handle;
        }

        static /* synthetic */ PointF access$1(PathHandle pathHandle) {
            return pathHandle.currentPoint;
        }
    }

    private class QuadToOperation
    implements Operation {
        private final float cx;
        private final float cy;
        private final float x;
        private final float y;

        public QuadToOperation(float cx, float cy, float x, float y) {
            this.cx = cx;
            this.cy = cy;
            this.x = x;
            this.y = y;
        }

        @Override
        public void apply(PathHandle pathHandle) {
            Device drawable = Path.this.getDevice();
            int zoom = pathHandle.zoom;
            float cxInPixels = Win32DPIUtils.pointToPixel((Drawable)drawable, this.cx, zoom);
            float cyInPixels = Win32DPIUtils.pointToPixel((Drawable)drawable, this.cy, zoom);
            float xInPixels = Win32DPIUtils.pointToPixel((Drawable)drawable, this.x, zoom);
            float yInPixels = Win32DPIUtils.pointToPixel((Drawable)drawable, this.y, zoom);
            this.quadToInPixels(pathHandle, cxInPixels, cyInPixels, xInPixels, yInPixels);
        }

        private void quadToInPixels(PathHandle pathHandle, float cx, float cy, float x, float y) {
            PointF currentPoint = pathHandle.currentPoint;
            long handle = pathHandle.handle;
            float cx1 = currentPoint.X + 2.0f * (cx - currentPoint.X) / 3.0f;
            float cy1 = currentPoint.Y + 2.0f * (cy - currentPoint.Y) / 3.0f;
            float cx2 = cx1 + (x - currentPoint.X) / 3.0f;
            float cy2 = cy1 + (y - currentPoint.Y) / 3.0f;
            Gdip.GraphicsPath_AddBezier(handle, currentPoint.X, currentPoint.Y, cx1, cy1, cx2, cy2, x, y);
            Gdip.GraphicsPath_GetLastPoint(handle, currentPoint);
        }
    }
}

