/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.action;

import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.CollapseAllAction;
import org.eclipse.emf.edit.ui.action.ControlAction;
import org.eclipse.emf.edit.ui.action.CopyAction;
import org.eclipse.emf.edit.ui.action.CutAction;
import org.eclipse.emf.edit.ui.action.DeleteAction;
import org.eclipse.emf.edit.ui.action.ExpandAllAction;
import org.eclipse.emf.edit.ui.action.FindAction;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.action.PasteAction;
import org.eclipse.emf.edit.ui.action.RedoAction;
import org.eclipse.emf.edit.ui.action.RevertAction;
import org.eclipse.emf.edit.ui.action.UndoAction;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheet;

public class EditingDomainActionBarContributor
extends MultiPageEditorActionBarContributor
implements IMenuListener,
IPropertyListener {
    protected IEditorPart activeEditor;
    protected DeleteAction deleteAction;
    protected CutAction cutAction;
    protected CopyAction copyAction;
    protected PasteAction pasteAction;
    protected UndoAction undoAction;
    protected RedoAction redoAction;
    protected LoadResourceAction loadResourceAction;
    protected ControlAction controlAction;
    protected ValidateAction validateAction;
    protected DiagnosticDecorator.LiveValidator.LiveValidationAction liveValidationAction;
    protected FindAction findAction;
    protected RevertAction revertAction;
    protected CollapseAllAction collapseAllAction;
    protected ExpandAllAction expandAllAction;
    public static final int ADDITIONS_LAST_STYLE = 1;
    protected int style;

    public EditingDomainActionBarContributor() {
    }

    public EditingDomainActionBarContributor(int style) {
        this.style = style;
    }

    public void init(IActionBars actionBars) {
        super.init(actionBars);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.deleteAction = this.createDeleteAction();
        this.deleteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        this.cutAction = this.createCutAction();
        this.cutAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
        this.copyAction = this.createCopyAction();
        this.copyAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        this.pasteAction = this.createPasteAction();
        this.pasteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        this.undoAction = this.createUndoAction();
        this.undoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        this.redoAction = this.createRedoAction();
        this.redoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
        if (this.findAction != null) {
            actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), (IAction)this.findAction);
        }
        if (this.revertAction != null) {
            actionBars.setGlobalActionHandler(ActionFactory.REVERT.getId(), (IAction)this.revertAction);
        }
    }

    protected DeleteAction createDeleteAction() {
        return new DeleteAction(this.removeAllReferencesOnDelete());
    }

    protected CutAction createCutAction() {
        return new CutAction();
    }

    protected CopyAction createCopyAction() {
        return new CopyAction();
    }

    protected PasteAction createPasteAction() {
        return new PasteAction();
    }

    protected UndoAction createUndoAction() {
        return new UndoAction();
    }

    protected RedoAction createRedoAction() {
        return new RedoAction();
    }

    protected boolean removeAllReferencesOnDelete() {
        return false;
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
    }

    public void contributeToStatusLine(IStatusLineManager statusLineManager) {
        super.contributeToStatusLine(statusLineManager);
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        super.contributeToToolBar(toolBarManager);
        toolBarManager.add((IContributionItem)new Separator("expand-collapse"));
        if (this.expandAllAction != null) {
            toolBarManager.add((IAction)this.expandAllAction);
        }
        if (this.collapseAllAction != null) {
            toolBarManager.add((IAction)this.collapseAllAction);
        }
        toolBarManager.add((IContributionItem)new Separator("expand-collapse-end"));
    }

    public void shareGlobalActions(IPage page, IActionBars actionBars) {
        if (!(page instanceof IPropertySheetPage)) {
            actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
            actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
            actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        }
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
        if (this.findAction != null) {
            actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), (IAction)this.findAction);
        }
        if (this.revertAction != null) {
            actionBars.setGlobalActionHandler(ActionFactory.REVERT.getId(), (IAction)this.revertAction);
        }
    }

    @Deprecated
    public void setActiveView(IViewPart part) {
        IActionBars actionBars = part.getViewSite().getActionBars();
        if (!(part instanceof PropertySheet)) {
            actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
            actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
            actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        }
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
        actionBars.updateActionBars();
    }

    public IEditorPart getActiveEditor() {
        return this.activeEditor;
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        if (part != this.activeEditor) {
            if (this.activeEditor != null) {
                this.deactivate();
            }
            if (part instanceof IEditingDomainProvider) {
                this.activeEditor = part;
                this.activate();
            }
        } else {
            EditorSite editorSite = (EditorSite)part.getEditorSite();
            editorSite.activateActionBars(part instanceof IEditingDomainProvider);
        }
    }

    public void setActivePage(IEditorPart part) {
    }

    public void deactivate() {
        ISelectionProvider selectionProvider;
        this.activeEditor.removePropertyListener((IPropertyListener)this);
        this.deleteAction.setActiveWorkbenchPart(null);
        this.cutAction.setActiveWorkbenchPart(null);
        this.copyAction.setActiveWorkbenchPart(null);
        this.pasteAction.setActiveWorkbenchPart(null);
        this.undoAction.setActiveWorkbenchPart(null);
        this.redoAction.setActiveWorkbenchPart(null);
        if (this.loadResourceAction != null) {
            this.loadResourceAction.setActiveWorkbenchPart(null);
        }
        if (this.controlAction != null) {
            this.controlAction.setActiveWorkbenchPart(null);
        }
        if (this.validateAction != null) {
            this.validateAction.setActiveWorkbenchPart(null);
        }
        if (this.liveValidationAction != null) {
            this.liveValidationAction.setActiveWorkbenchPart(null);
        }
        if (this.findAction != null) {
            this.findAction.setActiveWorkbenchPart(null);
        }
        if (this.revertAction != null) {
            this.revertAction.setActiveWorkbenchPart(null);
        }
        if (this.collapseAllAction != null) {
            this.collapseAllAction.setActiveWorkbenchPart(null);
        }
        if (this.expandAllAction != null) {
            this.expandAllAction.setActiveWorkbenchPart(null);
        }
        ISelectionProvider iSelectionProvider = selectionProvider = this.activeEditor instanceof ISelectionProvider ? (ISelectionProvider)this.activeEditor : this.activeEditor.getEditorSite().getSelectionProvider();
        if (selectionProvider != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.deleteAction);
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.cutAction);
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.copyAction);
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.pasteAction);
            if (this.validateAction != null) {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.validateAction);
            }
            if (this.controlAction != null) {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.controlAction);
            }
        }
    }

    public void activate() {
        ISelectionProvider selectionProvider;
        this.activeEditor.addPropertyListener((IPropertyListener)this);
        this.deleteAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        this.cutAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        this.copyAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        this.pasteAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        this.undoAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        this.redoAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        if (this.loadResourceAction != null) {
            this.loadResourceAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        }
        if (this.controlAction != null) {
            this.controlAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        }
        if (this.validateAction != null) {
            this.validateAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        }
        if (this.liveValidationAction != null) {
            this.liveValidationAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        }
        if (this.findAction != null) {
            this.findAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        }
        if (this.revertAction != null) {
            this.revertAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        }
        if (this.collapseAllAction != null) {
            this.collapseAllAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        }
        if (this.expandAllAction != null) {
            this.expandAllAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        }
        ISelectionProvider iSelectionProvider = selectionProvider = this.activeEditor instanceof ISelectionProvider ? (ISelectionProvider)this.activeEditor : this.activeEditor.getEditorSite().getSelectionProvider();
        if (selectionProvider != null) {
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.deleteAction);
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.cutAction);
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.copyAction);
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.pasteAction);
            if (this.validateAction != null) {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.validateAction);
            }
            if (this.controlAction != null) {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.controlAction);
            }
        }
        this.update();
    }

    public void update() {
        ISelectionProvider selectionProvider;
        ISelectionProvider iSelectionProvider = selectionProvider = this.activeEditor instanceof ISelectionProvider ? (ISelectionProvider)this.activeEditor : this.activeEditor.getEditorSite().getSelectionProvider();
        if (selectionProvider != null) {
            ISelection selection = selectionProvider.getSelection();
            StructuredSelection structuredSelection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : StructuredSelection.EMPTY;
            this.deleteAction.updateSelection((IStructuredSelection)structuredSelection);
            this.cutAction.updateSelection((IStructuredSelection)structuredSelection);
            this.copyAction.updateSelection((IStructuredSelection)structuredSelection);
            this.pasteAction.updateSelection((IStructuredSelection)structuredSelection);
            if (this.validateAction != null) {
                this.validateAction.updateSelection((IStructuredSelection)structuredSelection);
            }
            if (this.controlAction != null) {
                this.controlAction.updateSelection((IStructuredSelection)structuredSelection);
            }
        }
        this.undoAction.update();
        this.redoAction.update();
        if (this.loadResourceAction != null) {
            this.loadResourceAction.update();
        }
        if (this.liveValidationAction != null) {
            this.liveValidationAction.update();
        }
        if (this.findAction != null) {
            this.findAction.update();
        }
        if (this.revertAction != null) {
            this.revertAction.update();
        }
        if (this.collapseAllAction != null) {
            this.collapseAllAction.update();
        }
        if (this.expandAllAction != null) {
            this.expandAllAction.update();
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        if ((this.style & 1) == 0) {
            menuManager.add((IContributionItem)new Separator("additions"));
        }
        menuManager.add((IContributionItem)new Separator("edit"));
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.undoAction));
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.redoAction));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.cutAction));
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.copyAction));
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.pasteAction));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.deleteAction));
        menuManager.add((IContributionItem)new Separator());
        if (this.findAction != null) {
            menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.findAction));
            menuManager.add((IContributionItem)new Separator());
        }
        if ((this.style & 1) != 0) {
            menuManager.add((IContributionItem)new Separator("additions"));
            menuManager.add((IContributionItem)new Separator());
        }
        menuManager.add((IContributionItem)new Separator("additions-end"));
        this.addGlobalActions(menuManager);
    }

    protected void addGlobalActions(IMenuManager menuManager) {
        String key;
        String string = key = (this.style & 1) == 0 ? "additions-end" : "additions";
        if (this.validateAction != null) {
            menuManager.insertBefore(key, (IContributionItem)new ActionContributionItem((IAction)this.validateAction));
        }
        if (this.liveValidationAction != null) {
            menuManager.insertBefore(key, (IContributionItem)new ActionContributionItem((IAction)this.liveValidationAction));
        }
        if (this.controlAction != null) {
            menuManager.insertBefore(key, (IContributionItem)new ActionContributionItem((IAction)this.controlAction));
        }
        if (this.validateAction != null || this.controlAction != null) {
            menuManager.insertBefore(key, (IContributionItem)new Separator());
        }
        if (this.loadResourceAction != null) {
            menuManager.insertBefore("additions-end", (IContributionItem)new ActionContributionItem((IAction)this.loadResourceAction));
            menuManager.insertBefore("additions-end", (IContributionItem)new Separator());
        }
    }

    public void propertyChanged(Object source, int id) {
        this.update();
    }
}

