/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.jface.dialogs;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.passage.lic.jface.resource.LicensingImages;
import org.eclipse.passage.lic.runtime.inspector.HardwareInspector;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class HardwareInspectorDialog
extends TrayDialog {
    private final HardwareInspector hardwareInspector;

    public HardwareInspectorDialog(Shell shell, HardwareInspector inspector) {
        super(shell);
        this.hardwareInspector = inspector;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Hardware Inspector");
        newShell.setImage(LicensingImages.getImage("IMG_INSPECTOR"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Text text = new Text(area, 10);
        text.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        StringBuilder infoBuilder = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                this.hardwareInspector.dumpHardwareInfo((OutputStream)baos);
                infoBuilder.append(new String(baos.toByteArray()));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            infoBuilder.append(e.getMessage());
        }
        text.setText(infoBuilder.toString());
        return area;
    }

    protected boolean isResizable() {
        return true;
    }
}

