/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.panel;

import java.util.stream.StreamSupport;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;

public class DashboardPanelBlock {
    private String warning;
    private String info;
    private Text text;
    private ControlDecoration decoration;
    private Link edit;

    public void createControl(Composite parent, String label, Image image) {
        this.text = this.createTextBlock(parent, label, image);
        this.decoration = new ControlDecoration((Control)this.text, 16512);
        this.edit = new Link(parent, 0);
        this.edit.setText("<a>Edit</a>");
    }

    public void configureEdit(String tooltip, SelectionListener listener) {
        this.edit.setToolTipText(tooltip);
        this.edit.addSelectionListener(listener);
    }

    protected Text createTextBlock(Composite parent, String label, Image image) {
        Label imageLabel = new Label(parent, 0);
        imageLabel.setImage(image);
        Label textLabel = new Label(parent, 0);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 100;
        textLabel.setLayoutData((Object)data);
        textLabel.setText(label);
        Text text = new Text(parent, 8);
        GridData data2 = new GridData(4, 4, false, false);
        data2.widthHint = 50;
        data2.horizontalIndent = 5;
        text.setLayoutData((Object)data2);
        return text;
    }

    protected void decorateTextBlock(String warning, String info, long count, ControlDecoration decoration) {
        FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
        if (count > 0L) {
            Image image = registry.getFieldDecoration("DEC_INFORMATION").getImage();
            decoration.setImage(image);
            decoration.setDescriptionText(String.format(info, count));
        } else {
            Image image = registry.getFieldDecoration("DEC_WARNING").getImage();
            decoration.setImage(image);
            decoration.setDescriptionText(String.format(warning, count));
        }
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public void setWarning(String warning) {
        this.warning = warning;
    }

    public void update(Iterable<?> iterable) {
        this.update(StreamSupport.stream(iterable.spliterator(), false).count());
    }

    public void update(long count) {
        String value = String.valueOf(count);
        if (value.equals(this.text.getText())) {
            return;
        }
        this.text.setText(value);
        this.edit.setEnabled(count > 0L);
        this.decorateTextBlock(this.warning, this.info, count, this.decoration);
    }
}

