/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.panel;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.passage.lic.features.model.meta.FeaturesPackage;
import org.eclipse.passage.lic.features.registry.FeatureRegistry;
import org.eclipse.passage.lic.jface.resource.LicensingImages;
import org.eclipse.passage.lic.licenses.model.meta.LicensesPackage;
import org.eclipse.passage.lic.licenses.registry.LicenseRegistry;
import org.eclipse.passage.lic.products.model.meta.ProductsPackage;
import org.eclipse.passage.lic.products.registry.ProductRegistry;
import org.eclipse.passage.lic.users.model.meta.UsersPackage;
import org.eclipse.passage.lic.users.registry.UserRegistry;
import org.eclipse.passage.loc.dashboard.ui.DashboardUi;
import org.eclipse.passage.loc.dashboard.ui.panel.DashboardPanelAdvisor;
import org.eclipse.passage.loc.dashboard.ui.panel.DashboardPanelBlock;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class DefaultDashboardPanelAdvisor
implements DashboardPanelAdvisor {
    private IEclipseContext context;
    private DashboardPanelBlock featureSets;
    private DashboardPanelBlock features;
    private DashboardPanelBlock featureVersions;
    private DashboardPanelBlock productLines;
    private DashboardPanelBlock products;
    private DashboardPanelBlock productVersions;
    private DashboardPanelBlock productVersionFeatures;
    private DashboardPanelBlock userOrigins;
    private DashboardPanelBlock users;
    private DashboardPanelBlock licensePacks;

    @Override
    public void init(IEclipseContext context) {
        this.context = context;
    }

    @Override
    public void createHeaderInfo(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000000, 128).indent(0, 10).grab(true, false).create());
        label.setFont(JFaceResources.getBannerFont());
        label.setText("Licensing data overview");
    }

    @Override
    public void createFeatureInfo(Composite parent, FeatureRegistry featureRegistry) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        group.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(4).create());
        group.setText("Features");
        this.createLinks(group, "features");
        this.featureSets = this.createFeatureSetBlock((Composite)group);
        this.features = this.createFeatureBlock((Composite)group);
        this.featureVersions = this.createFeatureVersionBlock((Composite)group);
        this.updateFeatureInfo(featureRegistry);
    }

    protected DashboardPanelBlock createFeatureSetBlock(Composite parent) {
        DashboardPanelBlock block = new DashboardPanelBlock();
        String label = "Feature Sets:";
        EClass eClass = FeaturesPackage.eINSTANCE.getFeatureSet();
        Image image = this.getImage(eClass);
        block.createControl(parent, label, image);
        String info = "You have %s Feature Set(s) defined.\nUse it define the Features";
        String warning = "You have no Feature Sets defined.\nPlease create or load Feature Set definitions";
        block.setInfo(info);
        block.setWarning(warning);
        final String domain = "features";
        final String classifier = eClass.getName();
        block.configureEdit("Select Feature Set to edit", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefaultDashboardPanelAdvisor.this.executeEditCommand(domain, classifier);
            }
        });
        return block;
    }

    protected DashboardPanelBlock createFeatureBlock(Composite parent) {
        DashboardPanelBlock block = new DashboardPanelBlock();
        String label = "Features:";
        EClass eClass = FeaturesPackage.eINSTANCE.getFeature();
        Image image = this.getImage(eClass);
        block.createControl(parent, label, image);
        String info = "You have %s Feature(s) defined.\nUse it define the Feature Version(s)";
        String warning = "You have no Features defined.\nPlease create it for the Feature Set(s)";
        block.setInfo(info);
        block.setWarning(warning);
        final String domain = "features";
        final String classifier = eClass.getName();
        block.configureEdit("Select Feature to edit", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefaultDashboardPanelAdvisor.this.executeEditCommand(domain, classifier);
            }
        });
        return block;
    }

    protected DashboardPanelBlock createFeatureVersionBlock(Composite parent) {
        DashboardPanelBlock block = new DashboardPanelBlock();
        String label = "Feature Versions:";
        EClass eClass = FeaturesPackage.eINSTANCE.getFeatureVersion();
        Image image = this.getImage(eClass);
        block.createControl(parent, label, image);
        String info = "You have %s Feature Version(s) defined.\nUse it define the Product Version(s)";
        String warning = "You have no Feature Versions defined.\nPlease create it for the Feature(s)";
        block.setInfo(info);
        block.setWarning(warning);
        final String domain = "features";
        final String classifier = eClass.getName();
        block.configureEdit("Select Feature Version to edit", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefaultDashboardPanelAdvisor.this.executeEditCommand(domain, classifier);
            }
        });
        return block;
    }

    @Override
    public void updateFeatureInfo(FeatureRegistry featureRegistry) {
        this.featureSets.update(featureRegistry.getFeatureSets());
        this.features.update(featureRegistry.getFeatures());
        this.featureVersions.update(featureRegistry.getFeatureVersions());
    }

    @Override
    public void createProductInfo(Composite parent, ProductRegistry productRegistry) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        group.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(4).create());
        group.setText("Products");
        this.createLinks(group, "products");
        this.productLines = this.createProductLineBlock((Composite)group);
        this.products = this.createProductBlock((Composite)group, productRegistry);
        this.productVersions = this.createProductVersionBlock((Composite)group);
        this.productVersionFeatures = this.createProductVersionFeatureBlock((Composite)group);
        this.updateProductInfo(productRegistry);
    }

    protected DashboardPanelBlock createProductLineBlock(Composite parent) {
        DashboardPanelBlock block = new DashboardPanelBlock();
        String label = "Product Lines:";
        EClass eClass = ProductsPackage.eINSTANCE.getProductLine();
        Image image = this.getImage(eClass);
        block.createControl(parent, label, image);
        String info = "You have %s Product Line(s) defined.\nUse it define the Products";
        String warning = "You have no Product Lines defined.\nPlease create or load Product Line definitions";
        block.setInfo(info);
        block.setWarning(warning);
        final String domain = "products";
        final String classifier = eClass.getName();
        block.configureEdit("Select Product Line to edit", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefaultDashboardPanelAdvisor.this.executeEditCommand(domain, classifier);
            }
        });
        return block;
    }

    protected DashboardPanelBlock createProductBlock(Composite parent, ProductRegistry registry) {
        DashboardPanelBlock block = new DashboardPanelBlock();
        String label = "Products:";
        EClass eClass = ProductsPackage.eINSTANCE.getProduct();
        Image image = this.getImage(eClass);
        block.createControl(parent, label, image);
        String info = "You have %s Product(s) defined.\nUse it define the Product Versions";
        String warning = "You have no Products defined.\nPlease create it for the Product Line(s)";
        block.setInfo(info);
        block.setWarning(warning);
        final String domain = "products";
        final String classifier = eClass.getName();
        block.configureEdit("Select Product to edit", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefaultDashboardPanelAdvisor.this.executeEditCommand(domain, classifier);
            }
        });
        return block;
    }

    protected DashboardPanelBlock createProductVersionBlock(Composite parent) {
        DashboardPanelBlock block = new DashboardPanelBlock();
        String label = "Product Versions:";
        EClass eClass = ProductsPackage.eINSTANCE.getProductVersion();
        Image image = this.getImage(eClass);
        block.createControl(parent, label, image);
        String info = "You have %s Product Version (s) defined.\nUse it define the Product Version Features";
        String warning = "You have no Product Versions defined.\nPlease create it for the Product(s)";
        block.setInfo(info);
        block.setWarning(warning);
        final String domain = "products";
        final String classifier = eClass.getName();
        block.configureEdit("Select Product Version to edit", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefaultDashboardPanelAdvisor.this.executeEditCommand(domain, classifier);
            }
        });
        return block;
    }

    protected DashboardPanelBlock createProductVersionFeatureBlock(Composite parent) {
        DashboardPanelBlock block = new DashboardPanelBlock();
        String label = "Product Features:";
        EClass eClass = ProductsPackage.eINSTANCE.getProductVersionFeature();
        Image image = this.getImage(eClass);
        block.createControl(parent, label, image);
        String info = "You have %s Product Version Feature(s) defined.\nUse it define License Grants";
        String warning = "You have no Product Version Features defined.\nPlease create it for the Product Verion(s)";
        block.setInfo(info);
        block.setWarning(warning);
        final String domain = "products";
        final String classifier = eClass.getName();
        block.configureEdit("Select Product Version Feature to edit", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefaultDashboardPanelAdvisor.this.executeEditCommand(domain, classifier);
            }
        });
        return block;
    }

    @Override
    public void updateProductInfo(ProductRegistry productRegistry) {
        this.productLines.update(productRegistry.getProductLines());
        this.products.update(productRegistry.getProducts());
        this.productVersions.update(productRegistry.getProductVersions());
        this.productVersionFeatures.update(productRegistry.getProductVersionFeatures());
    }

    @Override
    public void createUserInfo(Composite parent, UserRegistry userRegistry) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        group.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(4).create());
        group.setText("Users");
        this.createLinks(group, "users");
        this.userOrigins = this.createUserOriginBlock((Composite)group);
        this.users = this.createUserBlock((Composite)group);
        this.updateUserInfo(userRegistry);
    }

    protected DashboardPanelBlock createUserOriginBlock(Composite parent) {
        DashboardPanelBlock block = new DashboardPanelBlock();
        String label = "User Origins:";
        EClass eClass = UsersPackage.eINSTANCE.getUserOrigin();
        Image image = this.getImage(eClass);
        block.createControl(parent, label, image);
        String info = "You have %s User Origin(s) defined.\nUse it define the Users";
        String warning = "You have no User Origins defined.\nPlease create or load User Origin definitions";
        block.setInfo(info);
        block.setWarning(warning);
        final String domain = "users";
        final String classifier = eClass.getName();
        block.configureEdit("Select User Origin to edit", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefaultDashboardPanelAdvisor.this.executeEditCommand(domain, classifier);
            }
        });
        return block;
    }

    protected DashboardPanelBlock createUserBlock(Composite parent) {
        DashboardPanelBlock block = new DashboardPanelBlock();
        String label = "Users:";
        EClass eClass = UsersPackage.eINSTANCE.getUser();
        Image image = this.getImage(eClass);
        block.createControl(parent, label, image);
        String info = "You have %s User(s) defined.\nUse it define the License Packs";
        String warning = "You have no Users defined.\nPlease create it for the User Origin(s)";
        block.setInfo(info);
        block.setWarning(warning);
        final String domain = "users";
        final String classifier = eClass.getName();
        block.configureEdit("Select User to edit", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefaultDashboardPanelAdvisor.this.executeEditCommand(domain, classifier);
            }
        });
        return block;
    }

    @Override
    public void updateUserInfo(UserRegistry userRegistry) {
        this.userOrigins.update(userRegistry.getUserOrigins());
        this.users.update(userRegistry.getUsers());
    }

    @Override
    public void createLicenseInfo(Composite parent, LicenseRegistry licenseRegistry) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        group.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(4).create());
        group.setText("Licenses");
        this.createLinks(group, "licenses");
        this.licensePacks = this.createLicensePackBlock((Composite)group);
        this.updateLicenseInfo(licenseRegistry);
    }

    protected DashboardPanelBlock createLicensePackBlock(Composite parent) {
        DashboardPanelBlock block = new DashboardPanelBlock();
        String label = "License Packs:";
        EClass eClass = LicensesPackage.eINSTANCE.getLicensePack();
        Image image = this.getImage(eClass);
        block.createControl(parent, label, image);
        String info = "You have %s License Pack(s) defined.\nUse it define the License Grants";
        String warning = "You have no License Packs defined.\nPlease create or load License Pack definitions";
        block.setInfo(info);
        block.setWarning(warning);
        final String domain = "licenses";
        final String classifier = eClass.getName();
        block.configureEdit("Select License Pack to edit", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefaultDashboardPanelAdvisor.this.executeEditCommand(domain, classifier);
            }
        });
        return block;
    }

    @Override
    public void updateLicenseInfo(LicenseRegistry licenseRegistry) {
        this.licensePacks.update(licenseRegistry.getLicensePacks());
    }

    @Override
    public void createFooterInfo(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000000, 128).indent(0, 10).grab(true, false).create());
        label.setText("Licensing data summary");
    }

    protected void createLinks(Group group, final String domain) {
        Link create = new Link((Composite)group, 0);
        create.setText("<a>Create</a>");
        create.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).span(2, 1).create());
        create.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefaultDashboardPanelAdvisor.this.executeCreateCommand(domain);
            }
        });
        Link open = new Link((Composite)group, 0);
        open.setText("<a>Load</a>");
        open.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).span(2, 1).create());
        open.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefaultDashboardPanelAdvisor.this.executeLoadCommand(domain);
            }
        });
    }

    protected void executeCreateCommand(String domain) {
        DashboardUi.executeCreateCommand(this.context, domain);
    }

    protected void executeLoadCommand(String domain) {
        DashboardUi.executeLoadCommand(this.context, domain);
    }

    protected void executeEditCommand(String domain, String classifier) {
        DashboardUi.executeEditCommand(this.context, domain, classifier);
    }

    protected Image getImage(EClass eClass) {
        return LicensingImages.getImage((String)eClass.getName());
    }

    @Override
    public void dispose(IEclipseContext context) {
        this.context = null;
    }
}

