/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.licenses.ui.handlers;

import javax.inject.Named;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.passage.lic.licenses.LicensePackDescriptor;
import org.eclipse.passage.loc.runtime.LicenseOperatorService;
import org.eclipse.swt.widgets.Shell;

public class LicenseExportHandler {
    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") LicensePackDescriptor licensePack, IEclipseContext context) {
        LicenseOperatorService licenseService = (LicenseOperatorService)context.get(LicenseOperatorService.class);
        Shell shell = (Shell)context.get(Shell.class);
        IStatus status = licenseService.issueLicensePack(licensePack);
        if (status.isOK()) {
            MessageDialog.openInformation((Shell)shell, (String)"License Pack Issued", (String)status.getMessage());
        } else {
            ErrorDialog.openError((Shell)shell, (String)"Error", (String)"Error during license pack export", (IStatus)status);
        }
    }

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") @Optional LicensePackDescriptor licensePack, IEclipseContext context) {
        LicenseOperatorService licenseService = (LicenseOperatorService)context.get(LicenseOperatorService.class);
        if (licenseService == null) {
            return false;
        }
        return licensePack != null;
    }
}

