/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.users.edit.providers;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.passage.lic.users.edit.UsersEditPlugin;
import org.eclipse.passage.lic.users.model.api.User;
import org.eclipse.passage.lic.users.model.meta.UsersFactory;
import org.eclipse.passage.lic.users.model.meta.UsersPackage;

public class UserItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public UserItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addIdentifierPropertyDescriptor(object);
            this.addEmailPropertyDescriptor(object);
            this.addFullNamePropertyDescriptor(object);
            this.addDescriptionPropertyDescriptor(object);
            this.addPreferredConditionTypePropertyDescriptor(object);
            this.addPreferredConditionExpressionPropertyDescriptor(object);
            this.addUserOriginPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addIdentifierPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_User_identifier_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_User_identifier_feature", "_UI_User_type"), (EStructuralFeature)UsersPackage.eINSTANCE.getUser_Identifier(), true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addEmailPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_User_email_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_User_email_feature", "_UI_User_type"), (EStructuralFeature)UsersPackage.eINSTANCE.getUser_Email(), true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addFullNamePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_User_fullName_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_User_fullName_feature", "_UI_User_type"), (EStructuralFeature)UsersPackage.eINSTANCE.getUser_FullName(), true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addDescriptionPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_User_description_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_User_description_feature", "_UI_User_type"), (EStructuralFeature)UsersPackage.eINSTANCE.getUser_Description(), true, true, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addPreferredConditionTypePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_User_preferredConditionType_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_User_preferredConditionType_feature", "_UI_User_type"), (EStructuralFeature)UsersPackage.eINSTANCE.getUser_PreferredConditionType(), true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addPreferredConditionExpressionPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_User_preferredConditionExpression_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_User_preferredConditionExpression_feature", "_UI_User_type"), (EStructuralFeature)UsersPackage.eINSTANCE.getUser_PreferredConditionExpression(), true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addUserOriginPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_User_userOrigin_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_User_userOrigin_feature", "_UI_User_type"), (EStructuralFeature)UsersPackage.eINSTANCE.getUser_UserOrigin(), true, false, true, null, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(UsersPackage.eINSTANCE.getUser_UserLicenses());
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/user.png"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        User user = (User)object;
        String email = user.getEmail();
        if (email == null || email.length() == 0) {
            return this.getString("_UI_User_type");
        }
        String fullName = user.getFullName();
        if (fullName == null || fullName.length() == 0) {
            return email;
        }
        return this.getString("_UI_User_text_pattern", new Object[]{email, fullName});
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(User.class)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 7: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(UsersPackage.eINSTANCE.getUser_UserLicenses(), UsersFactory.eINSTANCE.createUserLicense()));
    }

    public ResourceLocator getResourceLocator() {
        return UsersEditPlugin.INSTANCE;
    }
}

