/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.jface.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.passage.loc.internal.workbench.i18n.WorkbenchMessages;
import org.eclipse.passage.loc.jface.dialogs.ObjectSelectionStatusDialog;
import org.eclipse.passage.loc.jface.dialogs.ViewerSearchFilter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class FilteredSelectionDialog<T>
extends ObjectSelectionStatusDialog<T> {
    private static final int DIALOG_HEIGHT = 500;
    private static final int DIALOG_WIDTH = 400;
    private final boolean multi;
    private Image image;
    private Text filteringField;
    private Label resultingField;
    private TableViewer tableViewItems;
    private final List<Object> input = new ArrayList<Object>();
    private LabelProvider labelProvider = new LabelProvider();
    private ViewerSearchFilter<?> filter;

    public FilteredSelectionDialog(Shell parent, boolean multi, ViewerSearchFilter<?> filter) {
        super(parent);
        this.multi = multi;
        this.filter = filter;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setInput(Iterable<?> objects) {
        this.input.clear();
        objects.forEach(this.input::add);
    }

    public void setLabelProvider(LabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    @Override
    protected void computeResult() {
        List selectedElements = this.tableViewItems.getStructuredSelection().toList();
        this.setResult(selectedElements);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite content = new Composite(area, 0);
        content.setLayoutData((Object)new GridData(1808));
        Label lblFilteringField = new Label(content, 0);
        GridData data = new GridData(4, 4, true, false);
        lblFilteringField.setLayoutData((Object)data);
        lblFilteringField.setText(WorkbenchMessages.FilteredSelectionDialog_filtering_label);
        this.filteringField = new Text(content, 2048);
        data = new GridData(4, 4, true, false);
        this.filteringField.setLayoutData((Object)data);
        this.filteringField.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (FilteredSelectionDialog.this.filter != null) {
                    TableItem item;
                    FilteredSelectionDialog.this.filter.setFilteringText(FilteredSelectionDialog.this.getFilteringField());
                    FilteredSelectionDialog.this.tableViewItems.refresh();
                    Table table = FilteredSelectionDialog.this.tableViewItems.getTable();
                    if (table.getItemCount() > 0 && (item = table.getItem(0)) != null) {
                        FilteredSelectionDialog.this.resultingField.setText(item.getText());
                        table.setSelection(item);
                    }
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        content.setLayout((Layout)layout);
        Label lblListItems = new Label(content, 0);
        GridData data2 = new GridData(4, 4, true, false);
        lblListItems.setLayoutData((Object)data2);
        lblListItems.setText(WorkbenchMessages.FilteredSelectionDialog_items_label);
        this.tableViewItems = new TableViewer(content, (this.multi ? 2 : 4) | 0x800 | 0x200);
        this.tableViewItems.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewItems.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.tableViewItems.setInput(this.input);
        this.tableViewItems.setSelection((ISelection)new StructuredSelection(this.getInitialSelection().toArray()));
        this.tableViewItems.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = FilteredSelectionDialog.this.tableViewItems.getTable().getSelectionIndex();
                TableItem item = FilteredSelectionDialog.this.tableViewItems.getTable().getItem(selectionIndex);
                if (item != null) {
                    FilteredSelectionDialog.this.resultingField.setText(item.getText());
                }
            }
        });
        if (this.filter != null) {
            this.tableViewItems.setFilters(new ViewerFilter[]{this.filter});
        }
        GridData gd = new GridData(1808);
        FilteredSelectionDialog.applyDialogFont((Control)this.tableViewItems.getTable());
        gd.heightHint = this.tableViewItems.getTable().getItemHeight() * 15;
        this.tableViewItems.getTable().setLayoutData((Object)gd);
        this.tableViewItems.addDoubleClickListener(event -> this.handleDoubleClick());
        this.resultingField = new Label(content, 2048);
        GridData data3 = new GridData(4, 4, true, false);
        this.resultingField.setLayoutData((Object)data3);
        FilteredSelectionDialog.applyDialogFont((Control)content);
        return area;
    }

    protected void handleDoubleClick() {
        this.okPressed();
    }

    public String getFilteringField() {
        return this.filteringField.getText();
    }

    protected void configureShell(Shell shell) {
        shell.setMinimumSize(400, 500);
        if (this.image != null) {
            shell.setImage(this.image);
        }
        super.configureShell(shell);
    }
}

