/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.workbench.wizards;

import java.util.Objects;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.passage.lic.emf.edit.ClassifierInitializer;
import org.eclipse.passage.loc.internal.workbench.ClassifierMetadata;
import org.eclipse.passage.loc.internal.workbench.i18n.WorkbenchMessages;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class BaseClassifierWizardPage
extends WizardPage {
    protected final EClass eClass;
    protected final EStructuralFeature identification;
    protected final EStructuralFeature naming;
    protected final ClassifierInitializer classifierInitializer;
    protected final EObject eObject;
    protected final ModifyListener validator = e -> this.setPageComplete(this.validatePage());
    private Text textId;
    private Text textName;

    protected BaseClassifierWizardPage(String pageName, ClassifierMetadata metadata, ClassifierInitializer initializer) {
        super(pageName);
        Objects.requireNonNull(metadata, WorkbenchMessages.BaseClassifierWizardPage_e_null_metadata);
        Objects.requireNonNull(initializer, WorkbenchMessages.BaseClassifierWizardPage_e_null_initializer);
        this.eClass = metadata.eClass();
        this.eObject = this.eClass.getEPackage().getEFactoryInstance().create(this.eClass);
        this.identification = metadata.identification();
        this.naming = metadata.naming();
        this.classifierInitializer = initializer;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).create());
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).create());
        this.createFieldControls(composite);
        this.initControls(this.classifierInitializer);
        this.setPageComplete(this.validatePage());
        this.setControl((Control)composite);
    }

    protected void createFieldControls(Composite composite) {
        this.createIdentifierGroup(composite);
        this.createNameGroup(composite);
    }

    private void createNameGroup(Composite composite) {
        Label labelName = new Label(composite, 16384);
        labelName.setText(WorkbenchMessages.CreateFileWizardPage_label_name);
        labelName.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.textName = new Text(composite, 2048);
        this.textName.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 1).create());
        this.textName.addModifyListener(this.validator);
    }

    private void createIdentifierGroup(Composite composite) {
        Label labelId = new Label(composite, 16384);
        labelId.setText(WorkbenchMessages.CreateFileWizardPage_label_identifier);
        labelId.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.textId = new Text(composite, 2048);
        this.textId.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 1).create());
        this.textId.addModifyListener(this.validator);
    }

    protected void initControls(ClassifierInitializer initializer) {
        this.textId.setText(initializer.newObjectIdentifier());
        this.textName.setText(initializer.newObjectName());
    }

    protected boolean validatePage() {
        boolean validationResult = true;
        String id = this.textId.getText();
        this.eObject.eSet(this.identification, (Object)id);
        if (id.isEmpty()) {
            this.setMessage(WorkbenchMessages.CreateFileWizardPage_e_specify_identifier);
            validationResult = false;
        }
        String name = this.textName.getText();
        this.eObject.eSet(this.naming, (Object)name);
        if (name.isEmpty()) {
            this.setMessage(WorkbenchMessages.CreateFileWizardPage_e_specify_name);
            validationResult = false;
        }
        return validationResult;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.textId.setFocus();
    }

    protected EObject candidate() {
        return this.eObject;
    }
}

