/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.jface.dialogs;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.passage.lic.internal.jface.i18n.JFaceMessages;
import org.eclipse.passage.lic.jface.dialogs.LicensingPage;
import org.eclipse.passage.lic.jface.dialogs.LicensingPageContributor;
import org.eclipse.passage.lic.jface.dialogs.LicensingPages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class LicensingConfigurationDialog
extends TrayDialog {
    private static final String TAB_ID = "TAB_ID";
    private static String lastTabId = null;
    private Map<TabItem, LicensingPage> tab2page = new HashMap<TabItem, LicensingPage>();
    private TabFolder tabFolder;

    public LicensingConfigurationDialog(Shell shell) {
        super(shell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(JFaceMessages.LicensingConfigurationDialog_shell);
        newShell.setImage(Window.getDefaultImage());
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        boolean selected = false;
        if (this.tabFolder.getItemCount() > 0) {
            if (lastTabId != null) {
                TabItem[] items = this.tabFolder.getItems();
                int i = 0;
                while (i < items.length) {
                    if (items[i].getData(TAB_ID).equals(lastTabId)) {
                        this.tabFolder.setSelection(i);
                        this.tabSelected(items[i]);
                        selected = true;
                        break;
                    }
                    ++i;
                }
            }
            if (!selected) {
                this.tabSelected(this.tabFolder.getItem(0));
            }
        }
        Dialog.applyDialogFont((Control)this.tabFolder);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.tabFolder = new TabFolder(area, 0);
        this.createFolderItems(this.tabFolder);
        GridData folderData = new GridData(4, 4, true, true);
        folderData.widthHint = this.convertHorizontalDLUsToPixels(440);
        folderData.heightHint = this.convertVerticalDLUsToPixels(220);
        this.tabFolder.setLayoutData((Object)folderData);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicensingConfigurationDialog.this.tabSelected((TabItem)e.item);
            }
        });
        return area;
    }

    protected void createFolderItems(TabFolder folder) {
        Iterable<LicensingPageContributor> contributors = LicensingPages.getPageContributors();
        for (LicensingPageContributor pageContributor : contributors) {
            TabItem item = new TabItem(folder, 0);
            item.setText(pageContributor.getPageName());
            item.setData((Object)pageContributor);
            item.setData(TAB_ID, (Object)pageContributor.getPageIdentifier());
            Composite control = new Composite((Composite)folder, 0);
            control.setLayout((Layout)new GridLayout());
            item.setControl((Control)control);
        }
    }

    protected void tabSelected(TabItem item) {
        String id;
        Object data = item.getData();
        if (data instanceof LicensingPageContributor) {
            LicensingPageContributor element = (LicensingPageContributor)data;
            Composite pageComposite = (Composite)item.getControl();
            try {
                LicensingPage page = element.createPage();
                this.tab2page.put(item, page);
                page.createControl(pageComposite);
                Dialog.applyDialogFont((Control)pageComposite);
                item.setData((Object)page);
                item.addDisposeListener(e -> page.dispose());
            }
            catch (Exception e2) {
                Label label = new Label(pageComposite, 0);
                label.setText(e2.getMessage());
                item.setData(null);
            }
            pageComposite.layout(true, true);
        }
        lastTabId = id = (String)item.getData(TAB_ID);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        for (LicensingPage page : this.tab2page.values()) {
            page.accept();
        }
        super.okPressed();
    }

    public boolean close() {
        this.tab2page.clear();
        return super.close();
    }
}

