/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.workbench.wizards;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.passage.lic.api.LicensingResult;
import org.eclipse.passage.lic.base.LicensingResults;
import org.eclipse.passage.lic.emf.ecore.EditingDomainRegistry;
import org.eclipse.passage.lic.emf.edit.ClassifierInitializer;
import org.eclipse.passage.lic.jface.dialogs.LicensingResultDialogs;
import org.eclipse.passage.loc.internal.workbench.ClassifierMetadata;
import org.eclipse.passage.loc.internal.workbench.i18n.WorkbenchMessages;
import org.eclipse.passage.loc.internal.workbench.wizards.BaseClassifierWizard;
import org.eclipse.passage.loc.internal.workbench.wizards.RootClassifierWizardPage;
import org.eclipse.passage.loc.workbench.LocWokbench;
import org.eclipse.swt.widgets.Shell;

public final class RootClassifierWizard
extends BaseClassifierWizard<RootClassifierWizardPage> {
    public RootClassifierWizard(ClassifierMetadata metadata, ClassifierInitializer initializer, EditingDomainRegistry<?> registry) {
        super(metadata, initializer, registry);
    }

    @Override
    protected RootClassifierWizardPage createNewClassifierPage(ClassifierMetadata metadata, ClassifierInitializer initializer) {
        return new RootClassifierWizardPage(metadata, initializer, this.registry.getFileExtension());
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(false, false, m -> this.store(((RootClassifierWizardPage)this.newClassifierPage).path(), ((RootClassifierWizardPage)this.newClassifierPage).candidate()));
            return true;
        }
        catch (Exception exception) {
            this.process(exception);
            return false;
        }
    }

    protected void store(String path, EObject candidate) {
        URI fileURI = URI.createFileURI((String)path);
        Resource resource = this.resourceSet().createResource(fileURI);
        resource.getContents().add((Object)candidate);
        LocWokbench.save(resource);
        this.registry.registerSource(fileURI.toFileString());
    }

    protected ResourceSet resourceSet() {
        if (this.registry instanceof IEditingDomainProvider) {
            IEditingDomainProvider edProvider = (IEditingDomainProvider)this.registry;
            return edProvider.getEditingDomain().getResourceSet();
        }
        return new ResourceSetImpl();
    }

    protected void process(Exception exception) {
        LicensingResultDialogs.openMessageDialog((Shell)this.getShell(), (String)WorkbenchMessages.RootClassifierWizard_title_e_create, (LicensingResult)LicensingResults.createError((String)WorkbenchMessages.RootClassifierWizard_message_e_create, (String)((Object)((Object)this)).getClass().getName(), (Throwable)exception));
    }
}

