/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.internal.api.registry.Registry;
import org.eclipse.passage.lic.internal.api.registry.StringServiceId;
import org.eclipse.passage.lic.internal.api.requirements.Requirement;
import org.eclipse.passage.lic.internal.api.requirements.ResolvedRequirements;
import org.eclipse.passage.lic.internal.base.i18n.BaseMessages;
import org.eclipse.passage.lic.internal.base.requirements.UnsatisfiableRequirement;

public final class Requirements
implements Supplier<Set<Requirement>> {
    private final Registry<StringServiceId, ResolvedRequirements> registry;
    private final String feature;

    public Requirements(Registry<StringServiceId, ResolvedRequirements> registry, String feature) {
        this.registry = registry;
        this.feature = feature;
    }

    @Override
    public Set<Requirement> get() {
        Collection services = this.registry.services();
        if (!services.isEmpty()) {
            return services.stream().map(ResolvedRequirements.Smart::new).flatMap(service -> service.forFeature(this.feature).stream()).collect(Collectors.toSet());
        }
        return Collections.singleton(new UnsatisfiableRequirement(BaseMessages.getString("Requirements.mandatory_requirements_resolvers_demand"), BaseMessages.getString("Requirements.mandatory_requirements_resolvers_demand_author")).get());
    }
}

