/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.registry;

import java.util.Collection;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.api.registry.Registry;
import org.eclipse.passage.lic.internal.api.registry.Service;
import org.eclipse.passage.lic.internal.api.registry.ServiceId;
import org.eclipse.passage.lic.internal.base.i18n.BaseMessages;

public final class BaseRegistry<I extends ServiceId, S extends Service<I>>
implements Registry<I, S> {
    private final Supplier<Collection<S>> services;

    public BaseRegistry(Supplier<Collection<S>> services) {
        this.services = services;
    }

    public boolean hasService(I id) {
        return this.services.get().stream().anyMatch(s -> id.equals(s.id()));
    }

    public S service(I id) {
        return (S)this.services.get().stream().filter(s -> id.equals(s.id())).findFirst().orElseThrow(() -> new IllegalStateException(String.format(BaseMessages.getString("Registry.retrieve_absent_exception"), id)));
    }

    public Collection<S> services() {
        return this.services.get();
    }
}

