/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.json;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.passage.lbc.internal.api.persistence.BoundLicense;
import org.eclipse.passage.lbc.internal.api.persistence.PersistableLicense;
import org.eclipse.passage.lbc.internal.base.BaseBoundLicense;
import org.eclipse.passage.lbc.internal.base.ConditionIdentifier;
import org.eclipse.passage.lbc.internal.base.LicenseCapacity;
import org.eclipse.passage.lbc.internal.base.LicenseTaken;
import org.eclipse.passage.lbc.internal.base.persistence.LockFile;
import org.eclipse.passage.lbc.internal.base.persistence.LockFolder;
import org.eclipse.passage.lbc.json.LbcJsonObjectMapper;

public final class JsonPersistableLicense
extends PersistableLicense {
    private final LockFolder folder;

    public JsonPersistableLicense(BoundLicense license, LockFolder base) {
        super(license);
        Objects.requireNonNull(base, "JsonPersistableLicense::base");
        this.folder = base;
    }

    public void save() throws IOException {
        Files.writeString(new LockFile((Supplier)this.folder, this.get()).get(), (CharSequence)new LbcJsonObjectMapper().get().writeValueAsString((Object)this.get()), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public boolean takeOne() {
        try {
            this.offsetLicense(1).save();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean releaseOne() {
        try {
            this.offsetLicense(-1).save();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private JsonPersistableLicense offsetLicense(int offset) {
        return new JsonPersistableLicense((BoundLicense)new BaseBoundLicense(new ConditionIdentifier(this.get().identifier()), new LicenseTaken((Integer)((Optional)this.get().taken().get()).get() + offset), new LicenseCapacity(this.get().capacity())), this.folder);
    }
}

