/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.equinox;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.internal.api.Framework;
import org.eclipse.passage.lic.internal.api.FrameworkSupplier;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.internal.api.diagnostic.Trouble;
import org.eclipse.passage.lic.internal.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.internal.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.internal.base.diagnostic.BaseDiagnostic;
import org.eclipse.passage.lic.internal.base.diagnostic.code.NoFramework;
import org.eclipse.passage.lic.internal.base.diagnostic.code.SeveralFrameworks;
import org.eclipse.passage.lic.internal.equinox.i18n.AccessMessages;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public abstract class FrameworkAware {
    private final BundleContext context = FrameworkUtil.getBundle(FrameworkAware.class).getBundleContext();

    protected FrameworkAware() {
    }

    private Collection<ServiceReference<FrameworkSupplier>> frameworks() {
        try {
            return this.context.getServiceReferences(FrameworkSupplier.class, null);
        }
        catch (InvalidSyntaxException e) {
            return Collections.emptyList();
        }
    }

    private <T> ServiceInvocationResult<T> noFramework() {
        return new BaseServiceInvocationResult(new Trouble((TroubleCode)new NoFramework(), String.format(AccessMessages.EquinoxPassage_no_framework, new Object[0])));
    }

    private <T> ServiceInvocationResult<T> severalFrameworks(Collection<ServiceReference<FrameworkSupplier>> findings) {
        return new BaseServiceInvocationResult((Diagnostic)new BaseDiagnostic(findings.stream().map(foreign -> this.foreignFramework(findings.size(), (ServiceReference<FrameworkSupplier>)foreign)).collect(Collectors.toList()), Collections.emptyList()));
    }

    private Trouble foreignFramework(int singlings, ServiceReference<FrameworkSupplier> foreign) {
        return new Trouble((TroubleCode)new SeveralFrameworks(singlings), String.format(AccessMessages.EquinoxPassage_foreign_framework, foreign.getBundle().getSymbolicName()));
    }

    protected <T> ServiceInvocationResult<T> withFrameworkService(Function<Framework, ServiceInvocationResult<T>> invoke) {
        return this.withReference(reference -> Optional.ofNullable((FrameworkSupplier)this.context.getService(reference)).flatMap(Supplier::get).map(invoke::apply).orElseGet(this::noFramework), this::noFramework, this::severalFrameworks);
    }

    protected <T> Optional<T> withFramework(Function<Framework, T> invoke) {
        return this.withReference(reference -> Optional.ofNullable((FrameworkSupplier)this.context.getService(reference)).flatMap(Supplier::get).map(invoke::apply), Optional::empty, any -> Optional.empty());
    }

    private <K> K withReference(Function<ServiceReference<FrameworkSupplier>, K> onFramework, Supplier<K> onNoFramework, Function<Collection<ServiceReference<FrameworkSupplier>>, K> onSeveralFrameworks) {
        Collection<ServiceReference<FrameworkSupplier>> candidates = this.frameworks();
        if (candidates.isEmpty()) {
            return onNoFramework.get();
        }
        if (candidates.size() > 1) {
            return onSeveralFrameworks.apply(candidates);
        }
        ServiceReference<FrameworkSupplier> reference = candidates.iterator().next();
        try {
            K k = onFramework.apply(reference);
            return k;
        }
        finally {
            this.context.ungetService(reference);
        }
    }
}

