/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base;

import java.util.Objects;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.base.NamedData;
import org.eclipse.passage.lic.internal.base.ProductIdentifier;
import org.eclipse.passage.lic.internal.base.ProductVersion;

public final class BaseLicensedProduct
implements LicensedProduct {
    private final String identifier;
    private final String version;

    public BaseLicensedProduct(String product, String version) {
        Objects.requireNonNull(product, "BaseLicensedProduct::product");
        Objects.requireNonNull(version, "BaseLicensedProduct::version");
        this.identifier = product;
        this.version = version;
    }

    public String identifier() {
        return this.identifier;
    }

    public String version() {
        return this.version;
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.version);
    }

    public boolean equals(Object obj) {
        if (!LicensedProduct.class.isInstance(obj)) {
            return false;
        }
        LicensedProduct other = (LicensedProduct)obj;
        if (!Objects.equals(this.identifier, other.identifier())) {
            return false;
        }
        return Objects.equals(this.version, other.version());
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        new NamedData.Writable<String>(new ProductIdentifier(this.identifier)).write(output);
        output.append(';');
        new NamedData.Writable<String>(new ProductVersion(this.version)).write(output);
        return output.toString();
    }
}

