/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.hc.remote.impl;

import java.net.HttpURLConnection;
import java.util.Collections;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.internal.api.diagnostic.Trouble;
import org.eclipse.passage.lic.internal.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.internal.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.internal.base.diagnostic.BaseDiagnostic;
import org.eclipse.passage.lic.internal.base.diagnostic.code.ServiceFailedOnInfrastructureDenial;
import org.eclipse.passage.lic.internal.hc.i18n.AccessMessages;
import org.eclipse.passage.lic.internal.hc.remote.Client;
import org.eclipse.passage.lic.internal.hc.remote.Request;
import org.eclipse.passage.lic.internal.hc.remote.RequestContext;
import org.eclipse.passage.lic.internal.hc.remote.ResponseHandler;
import org.eclipse.passage.lic.internal.hc.remote.impl.NetConnection;
import org.eclipse.passage.lic.internal.hc.remote.impl.ResultsTransfered;

public final class HttpClient<T>
implements Client<NetConnection, T> {
    @Override
    public ServiceInvocationResult<T> request(Request<NetConnection> request, ResponseHandler<T> handler) {
        try {
            return this.netResults(this.connection(request), handler, request.context());
        }
        catch (Exception e) {
            return new BaseServiceInvocationResult((Diagnostic)new BaseDiagnostic(Collections.emptyList(), Collections.singletonList(new Trouble((TroubleCode)new ServiceFailedOnInfrastructureDenial(), AccessMessages.HttpClient_failure, e))));
        }
    }

    private NetConnection connection(Request<NetConnection> request) throws Exception {
        return request.config().apply(new NetConnection((HttpURLConnection)request.url().openConnection()));
    }

    private ServiceInvocationResult<T> netResults(NetConnection connection, ResponseHandler<T> handler, RequestContext context) throws Exception {
        ResultsTransfered results = new ResultsTransfered(connection);
        if (!results.successful()) {
            return new BaseServiceInvocationResult(results.diagnose());
        }
        return new BaseServiceInvocationResult(handler.read(results, context));
    }
}

