/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.wizards.license;

import java.util.Optional;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.passage.lic.internal.api.MandatoryService;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.LabeledField;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

final class SwitchField
extends LabeledField<Boolean> {
    private final String name;
    private Button switcher;

    protected SwitchField(String name, boolean value, Runnable modified, LabelProvider labels, MandatoryService context) {
        super(Optional.of(value), modified, labels, context);
        this.name = name;
    }

    @Override
    public Optional<String> error() {
        return Optional.empty();
    }

    @Override
    protected Control control(Composite parent) {
        this.installSwitch(parent);
        return this.switcher;
    }

    @Override
    protected void reflectData(Boolean data) {
        this.switcher.setSelection(data.booleanValue());
    }

    @Override
    protected void enableAuxiliaryControls(boolean enable) {
    }

    private void installSwitch(Composite parent) {
        this.switcher = new Button(parent, 32);
        this.switcher.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.changeState()));
        this.switcher.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        new Label(parent, 0).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private void changeState() {
        this.switcher.setData((Object)this.switcher.getSelection());
        this.modified.run();
    }

    @Override
    protected String label() {
        return this.name;
    }

    protected String errorText() {
        throw new UnsupportedOperationException();
    }
}

