/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.wizards.floating;

import java.util.Optional;
import java.util.function.Supplier;

abstract class ServerConfigsRequest {
    private final boolean generate;

    protected ServerConfigsRequest(boolean generate) {
        this.generate = generate;
    }

    boolean generate() {
        return this.generate;
    }

    abstract String ip();

    abstract int port();

    static final class Active
    extends ServerConfigsRequest {
        private final String ip;
        private final int port;

        Active(String ip, int port) {
            super(true);
            this.ip = ip;
            this.port = port;
        }

        @Override
        String ip() {
            return this.ip;
        }

        @Override
        int port() {
            return this.port;
        }
    }

    static final class Of
    implements Supplier<ServerConfigsRequest> {
        private final Supplier<Optional<Boolean>> generate;
        private final Supplier<Optional<String>> ip;
        private final Supplier<Optional<Integer>> port;

        Of(Supplier<Optional<Boolean>> generate, Supplier<Optional<String>> ip, Supplier<Optional<Integer>> port) {
            this.generate = generate;
            this.ip = ip;
            this.port = port;
        }

        @Override
        public ServerConfigsRequest get() {
            return this.generate.get().get() != false ? new Active(this.ip.get().get(), this.port.get().get()) : new Skip();
        }
    }

    static final class Skip
    extends ServerConfigsRequest {
        Skip() {
            super(false);
        }

        @Override
        String ip() {
            throw new UnsupportedOperationException();
        }

        @Override
        int port() {
            throw new UnsupportedOperationException();
        }
    }
}

