/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jetty;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.Request;
import org.eclipse.passage.lic.internal.net.api.handle.NetRequest;

public final class JettyRequest
implements NetRequest {
    private final Request origin;

    public JettyRequest(Request origin) {
        Objects.requireNonNull(origin, "JettyRequest::origin");
        this.origin = origin;
    }

    public String parameter(String name) {
        return Request.extractQueryParameters((Request)this.origin).getValue(name);
    }

    public byte[] content() throws IOException {
        HttpField field = this.origin.getHeaders().getField(HttpHeader.CONTENT_LENGTH);
        long length = field.getLongValue();
        byte[] content = new byte[(int)length];
        Throwable throwable = null;
        Object var6_6 = null;
        try (InputStream stream = Request.asInputStream((Request)this.origin);){
            stream.read(content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return content;
    }
}

