/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.report.internal.core.license;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.passage.lic.licenses.FloatingLicensePackDescriptor;
import org.eclipse.passage.lic.licenses.LicensePlanDescriptor;
import org.eclipse.passage.lic.licenses.PersonalLicensePackDescriptor;
import org.eclipse.passage.loc.internal.licenses.LicenseRegistry;
import org.eclipse.passage.loc.report.internal.core.license.LicenseStorage;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public final class Licenses
implements LicenseStorage {
    private LicenseRegistry licenses;

    @Override
    public List<LicensePlanDescriptor> plans() {
        return StreamSupport.stream(this.licenses.getLicensePlans().spliterator(), false).collect(Collectors.toList());
    }

    @Override
    public List<? extends PersonalLicensePackDescriptor> personal(String plan) {
        return this.licenses(plan, LicensePlanDescriptor::getPersonal);
    }

    @Override
    public List<? extends FloatingLicensePackDescriptor> floating(String plan) {
        return this.licenses(plan, LicensePlanDescriptor::getFloating);
    }

    private <T> List<T> licenses(String plan, Function<LicensePlanDescriptor, List<T>> get) {
        Optional<LicensePlanDescriptor> mayBePlan = this.plan(plan);
        if (!mayBePlan.isPresent()) {
            return Collections.emptyList();
        }
        return get.apply(mayBePlan.get());
    }

    @Override
    public Optional<LicensePlanDescriptor> plan(String plan) {
        return Optional.ofNullable(this.licenses.getLicensePlan(plan));
    }

    @Reference
    public void installLicenseRegistry(LicenseRegistry registry) {
        this.licenses = registry;
    }
}

