/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.workbench;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.passage.loc.internal.workbench.i18n.WorkbenchMessages;
import org.eclipse.passage.loc.jface.dialogs.Appearance;
import org.eclipse.passage.loc.jface.dialogs.FilteredSelectionDialog;
import org.eclipse.passage.loc.jface.dialogs.LabelSearchFilter;
import org.eclipse.swt.widgets.Shell;

public final class SelectSeveralFromDialog<C>
implements Function<Collection<C>, Collection<C>> {
    private final Supplier<Shell> shellSupplier;
    private final Appearance appearance;
    private final Collection<C> initial;

    public SelectSeveralFromDialog(Supplier<Shell> supplier, Appearance appearance) {
        this(supplier, appearance, Collections.emptyList());
    }

    public SelectSeveralFromDialog(Supplier<Shell> supplier, Appearance appearance, Collection<C> initial) {
        Objects.requireNonNull(supplier, WorkbenchMessages.SelectFromDialog_e_null_shell);
        Objects.requireNonNull(appearance, WorkbenchMessages.SelectFromDialog_e_null_appearance);
        Objects.requireNonNull(initial, WorkbenchMessages.SelectFromDialog_e_null_initial);
        this.shellSupplier = supplier;
        this.appearance = appearance;
        this.initial = new ArrayList<C>(initial);
    }

    @Override
    public Collection<C> apply(Collection<C> input) {
        FilteredSelectionDialog dialog = new FilteredSelectionDialog(this.shellSupplier.get(), true, new LabelSearchFilter());
        dialog.setTitle(this.appearance.title());
        dialog.setImage(this.appearance.image().get());
        dialog.setLabelProvider(this.appearance.labelProvider());
        dialog.setInitialSelection(this.initial);
        dialog.setInput(input);
        if (dialog.open() == 0) {
            return dialog.getResult();
        }
        return Collections.emptyList();
    }
}

