/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.diagnostic;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.function.Supplier;
import org.eclipse.passage.lic.api.diagnostic.Trouble;
import org.eclipse.passage.lic.internal.base.i18n.DiagnosticExplainedMessages;

public final class TroubleExplained
implements Supplier<String> {
    private final Trouble trouble;

    public TroubleExplained(Trouble trouble) {
        this.trouble = trouble;
    }

    @Override
    public String get() {
        StringBuilder out = new StringBuilder();
        out.append("\r\n\t> ").append(this.trouble.details()).append("\n\t\t(").append(this.trouble.code().code()).append(": ").append(this.trouble.code().explanation()).append(")").append(this.trouble.exception().isPresent() ? DiagnosticExplainedMessages.getString("DiagnosticExplained.failure") : "");
        if (this.trouble.exception().isPresent()) {
            StringWriter media = new StringWriter();
            ((Exception)this.trouble.exception().get()).printStackTrace(new PrintWriter(media));
            out.append("\r\n----\r\n").append(media.toString()).append("----\r\n");
        }
        return out.toString();
    }
}

