/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.users.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.internal.equinox.events.EquinoxEvent;
import org.eclipse.passage.lic.internal.users.model.util.UsersResourceImpl;
import org.eclipse.passage.lic.users.model.api.User;
import org.eclipse.passage.lic.users.model.api.UserOrigin;
import org.eclipse.passage.lic.users.model.meta.UsersPackage;
import org.eclipse.passage.loc.internal.api.OperatorGearSupplier;
import org.eclipse.passage.loc.internal.api.workspace.KnownResources;
import org.eclipse.passage.loc.internal.api.workspace.OperatorWorkspace;
import org.eclipse.passage.loc.internal.api.workspace.ResourceHandle;
import org.eclipse.passage.loc.internal.api.workspace.Users;
import org.eclipse.passage.loc.internal.emf.DomainContentAdapter;
import org.eclipse.passage.loc.internal.emf.EditingDomainRegistry;
import org.eclipse.passage.loc.internal.equinox.BaseDomainRegistry;
import org.eclipse.passage.loc.internal.users.UserRegistry;
import org.eclipse.passage.loc.internal.users.core.UsersDomainRegistryTracker;
import org.eclipse.passage.loc.internal.users.core.i18n.UsersCoreMessages;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.event.EventAdmin;

@Component(property={"org.eclipse.passage.lic.emf.edit.domain.name=users", "org.eclipse.passage.lic.emf.edit.file.extension=users_xmi"})
public final class UserDomainRegistry
extends BaseDomainRegistry<UserOrigin>
implements UserRegistry,
EditingDomainRegistry<UserOrigin> {
    private final Map<String, UserOrigin> origins = new HashMap<String, UserOrigin>();
    private final Map<String, User> users = new HashMap<String, User>();
    private final List<EventAdmin> events = new ArrayList<EventAdmin>();

    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    public void bindEventAdmin(EventAdmin admin) {
        this.events.add(admin);
    }

    public void unbindEventAdmin(EventAdmin admin) {
        this.events.remove(admin);
    }

    @Reference
    public void bindGear(OperatorGearSupplier supplier) {
        super.bindGear(supplier);
    }

    public void unbindGear(OperatorGearSupplier supplier) {
        super.unbindGear(supplier);
    }

    @Activate
    public void load(Map<String, Object> properties) {
        super.activate(properties);
    }

    @Deactivate
    public void unload(Map<String, Object> properties) {
        this.users.clear();
        this.origins.clear();
        super.deactivate(properties);
    }

    public String getFileExtension() {
        return "users_xmi";
    }

    public Class<UserOrigin> getContentClass() {
        return UserOrigin.class;
    }

    public String resolveIdentifier(UserOrigin content) {
        return content.getIdentifier();
    }

    @Override
    public Collection<UserOrigin> userOrigins() {
        return new ArrayList<UserOrigin>(this.origins.values());
    }

    @Override
    public Optional<UserOrigin> userOrigin(String identifier) {
        return Optional.ofNullable(this.origins.get(identifier));
    }

    @Override
    public Collection<User> users() {
        return new ArrayList<User>(this.users.values());
    }

    @Override
    public Optional<User> user(String identifier) {
        return Optional.ofNullable(this.users.get(identifier));
    }

    protected DomainContentAdapter<UserOrigin, UserDomainRegistry> createContentAdapter() {
        return new UsersDomainRegistryTracker(this);
    }

    void registerUserOrigin(UserOrigin origin) {
        UserOrigin existing = this.origins.put(origin.getIdentifier(), origin);
        if (existing != null && existing != origin) {
            Platform.getLog(this.getClass()).warn(NLS.bind((String)UsersCoreMessages.UserDomain_instance_duplication_message, (Object)existing, (Object)origin));
        }
        this.events().postEvent(new EquinoxEvent("org/eclipse/passage/lic/users/registry/UserOrigin/create", (Object)origin).get());
        origin.getUsers().forEach(u -> this.registerUser((User)u));
    }

    void registerUser(User user) {
        User existing = this.users.put(user.getContact().getEmail(), user);
        if (existing != null && existing != user) {
            Platform.getLog(this.getClass()).warn(NLS.bind((String)UsersCoreMessages.UserDomain_instance_duplication_message, (Object)existing, (Object)user));
        }
        this.events().postEvent(new EquinoxEvent("org/eclipse/passage/lic/users/registry/User/create", (Object)user).get());
    }

    void unregisterUserOrigin(String id) {
        UserOrigin removed = this.origins.remove(id);
        if (removed != null) {
            this.events().postEvent(new EquinoxEvent("org/eclipse/passage/lic/users/registry/UserOrigin/delete", (Object)removed).get());
            removed.getUsers().forEach(u -> this.unregisterUser(u.getContact().getEmail()));
        }
    }

    void unregisterUser(String userId) {
        User removed = this.users.remove(userId);
        if (removed != null) {
            this.events().postEvent(new EquinoxEvent("org/eclipse/passage/lic/users/registry/User/delete", (Object)removed).get());
        }
    }

    private EventAdmin events() {
        return (EventAdmin)this.events.stream().findAny().get();
    }

    public EClass getContentClassifier() {
        return UsersPackage.eINSTANCE.getUserOrigin();
    }

    public EStructuralFeature getContentIdentifierAttribute() {
        return UsersPackage.eINSTANCE.getUserOrigin_Identifier();
    }

    public EStructuralFeature getContentNameAttribute() {
        return UsersPackage.eINSTANCE.getUserOrigin_Name();
    }

    public void registerContent(UserOrigin content) {
        this.registerUserOrigin(content);
    }

    public void unregisterContent(String identifier) {
        this.unregisterUserOrigin(identifier);
    }

    protected final Resource createResource(URI uri) {
        return new UsersResourceImpl(uri);
    }

    protected boolean emfResource(ResourceHandle handle) {
        return Users.xmi.equals(handle.type()) || Users.xmi033.equals(handle.type());
    }

    protected KnownResources knownResources(OperatorWorkspace workspace) {
        return workspace.users();
    }
}

