/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.features.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.features.model.api.Feature;
import org.eclipse.passage.lic.features.model.api.FeatureSet;
import org.eclipse.passage.lic.features.model.api.FeatureVersion;
import org.eclipse.passage.lic.features.model.meta.FeaturesPackage;
import org.eclipse.passage.lic.internal.equinox.events.EquinoxEvent;
import org.eclipse.passage.lic.internal.features.model.util.FeaturesResourceImpl;
import org.eclipse.passage.loc.internal.api.OperatorGearSupplier;
import org.eclipse.passage.loc.internal.api.workspace.Features;
import org.eclipse.passage.loc.internal.api.workspace.KnownResources;
import org.eclipse.passage.loc.internal.api.workspace.OperatorWorkspace;
import org.eclipse.passage.loc.internal.api.workspace.ResourceHandle;
import org.eclipse.passage.loc.internal.emf.DomainContentAdapter;
import org.eclipse.passage.loc.internal.emf.EditingDomainRegistry;
import org.eclipse.passage.loc.internal.equinox.BaseDomainRegistry;
import org.eclipse.passage.loc.internal.features.FeatureRegistry;
import org.eclipse.passage.loc.internal.features.core.FeaturesDomainRegistryTracker;
import org.eclipse.passage.loc.internal.features.core.i18n.FeaturesCoreMessages;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.event.EventAdmin;

@Component(property={"org.eclipse.passage.lic.emf.edit.domain.name=features", "org.eclipse.passage.lic.emf.edit.file.extension=features_xmi"})
public final class FeatureDomainRegistry
extends BaseDomainRegistry<FeatureSet>
implements FeatureRegistry,
EditingDomainRegistry<FeatureSet> {
    private final Map<String, FeatureSet> sets = new HashMap<String, FeatureSet>();
    private final Map<String, Feature> features = new HashMap<String, Feature>();
    private final Map<String, Map<String, FeatureVersion>> versions = new HashMap<String, Map<String, FeatureVersion>>();
    private final List<EventAdmin> events = new ArrayList<EventAdmin>();

    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    public void bindEventAdmin(EventAdmin admin) {
        this.events.add(admin);
    }

    public void unbindEventAdmin(EventAdmin admin) {
        this.events.remove(admin);
    }

    @Reference
    public void bindGear(OperatorGearSupplier supplier) {
        super.bindGear(supplier);
    }

    public void unbindGear(OperatorGearSupplier supplier) {
        super.unbindGear(supplier);
    }

    @Activate
    public void load(Map<String, Object> properties) {
        super.activate(properties);
    }

    @Deactivate
    public void unload(Map<String, Object> properties) {
        this.versions.values().forEach(Map::clear);
        this.versions.clear();
        this.features.clear();
        this.sets.clear();
        super.deactivate(properties);
    }

    public String getFileExtension() {
        return "features_xmi";
    }

    public Class<FeatureSet> getContentClass() {
        return FeatureSet.class;
    }

    public String resolveIdentifier(FeatureSet content) {
        return content.getIdentifier();
    }

    @Override
    public Collection<FeatureSet> featureSets() {
        return new ArrayList<FeatureSet>(this.sets.values());
    }

    @Override
    public Optional<FeatureSet> featureSet(String identifier) {
        return Optional.ofNullable(this.sets.get(identifier));
    }

    @Override
    public Collection<Feature> features() {
        return new ArrayList<Feature>(this.features.values());
    }

    @Override
    public Optional<Feature> feature(String id) {
        return Optional.ofNullable(this.features.get(id));
    }

    @Override
    public Collection<FeatureVersion> featureVersions() {
        ArrayList<FeatureVersion> list = new ArrayList<FeatureVersion>();
        Collection<Map<String, FeatureVersion>> values = this.versions.values();
        for (Map<String, FeatureVersion> map : values) {
            list.addAll(map.values());
        }
        return list;
    }

    protected DomainContentAdapter<FeatureSet, FeatureDomainRegistry> createContentAdapter() {
        return new FeaturesDomainRegistryTracker(this);
    }

    void registerFeatureSet(FeatureSet fs) {
        FeatureSet existing = this.sets.put(fs.getIdentifier(), fs);
        if (existing != null && existing != fs) {
            Platform.getLog(this.getClass()).warn(NLS.bind((String)FeaturesCoreMessages.FeatureDomain_instance_duplication_message, (Object)existing, (Object)fs));
        }
        this.events().postEvent(new EquinoxEvent("org/eclipse/passage/lic/features/registry/FeatureSet/create", (Object)fs).get());
        fs.getFeatures().forEach(this::registerFeature);
    }

    void registerFeature(Feature feature) {
        Feature existing = this.features.put(feature.getIdentifier(), feature);
        if (existing != null && existing != feature) {
            Platform.getLog(this.getClass()).warn(NLS.bind((String)FeaturesCoreMessages.FeatureDomain_instance_duplication_message, (Object)existing, (Object)feature));
        }
        this.events().postEvent(new EquinoxEvent("org/eclipse/passage/lic/features/registry/Feature/create", (Object)feature).get());
        feature.getFeatureVersions().forEach(fv -> this.registerFeatureVersion(feature, (FeatureVersion)fv));
    }

    void registerFeatureVersion(Feature feature, FeatureVersion version) {
        String identifier = feature.getIdentifier();
        Map map = this.versions.computeIfAbsent(identifier, key -> new HashMap());
        FeatureVersion existing = map.put(version.getVersion(), version);
        if (existing != null && existing != version) {
            Platform.getLog(this.getClass()).warn(NLS.bind((String)FeaturesCoreMessages.FeatureDomain_instance_duplication_message, (Object)existing, (Object)version));
        }
        this.events().postEvent(new EquinoxEvent("org/eclipse/passage/lic/features/registry/FeatureVersion/create", (Object)version).get());
    }

    void unregisterFeatureSet(String id) {
        FeatureSet removed = this.sets.remove(id);
        if (removed != null) {
            this.events().postEvent(new EquinoxEvent("org/eclipse/passage/lic/features/registry/FeatureSet/delete", (Object)removed).get());
            removed.getFeatures().stream().map(Feature::getIdentifier).forEach(this::unregisterFeature);
        }
    }

    void unregisterFeature(String id) {
        Feature removed = this.features.remove(id);
        if (removed != null) {
            this.events().postEvent(new EquinoxEvent("org/eclipse/passage/lic/features/registry/Feature/delete", (Object)removed).get());
            removed.getFeatureVersions().forEach(fv -> this.unregisterFeatureVersion(id, fv.getVersion()));
        }
    }

    void unregisterFeatureVersion(String featureId, String version) {
        Map<String, FeatureVersion> map = this.versions.get(featureId);
        if (map != null) {
            FeatureVersion removed = map.remove(version);
            if (removed != null) {
                this.events().postEvent(new EquinoxEvent("org/eclipse/passage/lic/features/registry/FeatureVersion/delete", (Object)removed).get());
            }
            if (map.isEmpty()) {
                this.versions.remove(version);
            }
        }
    }

    private EventAdmin events() {
        return (EventAdmin)this.events.stream().findAny().get();
    }

    public EClass getContentClassifier() {
        return FeaturesPackage.eINSTANCE.getFeatureSet();
    }

    public EStructuralFeature getContentIdentifierAttribute() {
        return FeaturesPackage.eINSTANCE.getFeatureSet_Identifier();
    }

    public EStructuralFeature getContentNameAttribute() {
        return FeaturesPackage.eINSTANCE.getFeatureSet_Name();
    }

    public void registerContent(FeatureSet content) {
        this.registerFeatureSet(content);
    }

    public void unregisterContent(String identifier) {
        this.unregisterFeatureSet(identifier);
    }

    protected final Resource createResource(URI uri) {
        return new FeaturesResourceImpl(uri);
    }

    protected boolean emfResource(ResourceHandle handle) {
        return Features.xmi.equals(handle.type()) || Features.xmi033.equals(handle.type());
    }

    protected KnownResources knownResources(OperatorWorkspace workspace) {
        return workspace.features();
    }
}

