/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core;

import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.licenses.model.EmptyPersonalFeatureGrant;
import org.eclipse.passage.lic.licenses.model.api.LicensePlanFeature;
import org.eclipse.passage.lic.licenses.model.api.PersonalFeatureGrant;
import org.eclipse.passage.lic.licenses.model.api.ValidityPeriodClosed;
import org.eclipse.passage.loc.internal.api.PersonalLicenseRequest;

final class LicenseGrantFromRequest
implements Supplier<PersonalFeatureGrant> {
    private final LicensePlanFeature feature;
    private final PersonalLicenseRequest request;

    public LicenseGrantFromRequest(LicensePlanFeature feature, PersonalLicenseRequest request) {
        this.feature = feature;
        this.request = request;
    }

    @Override
    public PersonalFeatureGrant get() {
        PersonalFeatureGrant grant = new EmptyPersonalFeatureGrant().get();
        grant.getFeature().setIdentifier(this.feature.getFeature().getIdentifier());
        grant.getFeature().getVersionMatch().setVersion(this.feature.getFeature().getVersionMatch().getVersion());
        grant.getFeature().getVersionMatch().setRule(this.feature.getFeature().getVersionMatch().getRule());
        grant.setCapacity(1);
        grant.getUserAuthentication().setExpression(this.request.conditionExpression());
        grant.getUserAuthentication().setType(this.request.conditionType());
        ((ValidityPeriodClosed)grant.getValid()).setFrom(this.request.validFrom());
        ((ValidityPeriodClosed)grant.getValid()).setUntil(this.request.validUntil());
        return grant;
    }
}

