/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core;

import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.passage.lic.api.Framework;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.conditions.ConditionOrigin;
import org.eclipse.passage.lic.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.api.requirements.Requirement;
import org.eclipse.passage.lic.api.restrictions.ExaminationCertificate;
import org.eclipse.passage.lic.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.base.diagnostic.DiagnosticExplained;
import org.eclipse.passage.lic.equinox.EquinoxPassage;
import org.eclipse.passage.lic.equinox.SuppliedFrameworkAware;
import org.eclipse.passage.lic.internal.licenses.convert.EIssuerSignature;
import org.eclipse.passage.lic.internal.licenses.model.signature.SignatureData;
import org.eclipse.passage.lic.licenses.model.api.LicenseRequisites;
import org.eclipse.passage.lic.licenses.model.api.Signature;
import org.eclipse.passage.lic.licenses.model.meta.LicensesFactory;
import org.eclipse.passage.loc.internal.licenses.core.LicensingOperatorRequirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LicenseSignature
implements Consumer<LicenseRequisites> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    LicenseSignature() {
    }

    @Override
    public void accept(LicenseRequisites license) {
        ServiceInvocationResult response = new SuppliedFrameworkAware().withFrameworkService(this::product);
        if (response.data().isEmpty()) {
            this.report(response.diagnostic());
            return;
        }
        license.setSignature(this.signature((LicensedProduct)response.data().get()));
    }

    private void report(Diagnostic diagnostic) {
        this.log.error(new DiagnosticExplained(diagnostic).get());
    }

    private ServiceInvocationResult<LicensedProduct> product(Framework framework) {
        return new BaseServiceInvocationResult((Object)framework.product());
    }

    private Signature signature(LicensedProduct operator) {
        Signature signature = LicensesFactory.eINSTANCE.createSignature();
        new SignatureData.LicensingOperatorName(signature).put(operator.identifier());
        new SignatureData.LicensingOperatorVersion(signature).put(operator.version());
        this.installParentSignature(signature, operator);
        return signature;
    }

    private void installParentSignature(Signature signature, LicensedProduct operator) {
        ServiceInvocationResult assess = new EquinoxPassage().assess();
        if (assess.data().isEmpty()) {
            this.report(assess.diagnostic());
            return;
        }
        ExaminationCertificate certificate = (ExaminationCertificate)assess.data().get();
        Object requirement = new LicensingOperatorRequirement(certificate, operator).get();
        if (((Optional)requirement).isEmpty()) {
            new SignatureData.OperatorLicensingStatus(signature).notRequired();
            return;
        }
        if (!certificate.satisfied().contains(((Optional)requirement).get())) {
            new SignatureData.OperatorLicensingStatus(signature).insufficient();
            return;
        }
        new SignatureData.OperatorLicensingStatus(signature).sufficient();
        this.installParentSignature(signature, certificate.satisfaction((Requirement)((Optional)requirement).get()).conditionOrigin());
    }

    private void installParentSignature(Signature signature, ConditionOrigin origin) {
        signature.setParent(new EIssuerSignature(origin.signature()).get());
    }
}

