/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core.issue;

import org.eclipse.passage.lic.licenses.model.api.FeatureGrant;
import org.eclipse.passage.loc.internal.licenses.core.i18n.ReductionMessages;
import org.eclipse.passage.loc.internal.licenses.core.issue.Reduction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FeatureGrantCapacityReduction
implements Reduction<FeatureGrant> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final int capacity = 3;

    FeatureGrantCapacityReduction() {
    }

    @Override
    public void accept(FeatureGrant grant) {
        if (grant.getCapacity() <= 3) {
            return;
        }
        this.log.warn(String.format(ReductionMessages.FeatureGrantCapacityReduction_reduction_featuregrant_capacity, 3));
        this.log.warn(String.format(ReductionMessages.FeatureGrantCapacityReduction_reduction_featuregrant_feature, grant.getFeature(), 3));
        grant.setCapacity(3);
    }
}

