/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.workbench.emfforms.renderers;

import javax.inject.Inject;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlSWTControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.passage.lic.jface.resource.LicensingColorResolver;
import org.eclipse.passage.loc.internal.workbench.emfforms.i18n.WorkbenchEmfformsMessages;
import org.eclipse.passage.loc.jface.LocImages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class TextWithButtonRenderer
extends SimpleControlSWTControlSWTRenderer {
    protected Composite base;
    protected Text text;
    protected Button button;
    private final LicensingColorResolver licensingColors;
    private final LocImages locImages;

    @Inject
    public TextWithButtonRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
        this.licensingColors = (LicensingColorResolver)viewContext.getService(LicensingColorResolver.class);
        this.locImages = (LocImages)viewContext.getService(LocImages.class);
    }

    public LicensingColorResolver getLicensingColors() {
        return this.licensingColors;
    }

    public LocImages getLocImages() {
        return this.locImages;
    }

    protected Binding[] createBindings(Control control) throws DatabindingFailedException {
        if (control instanceof Text) {
            ISWTObservableValue observe = WidgetProperties.text((int)24).observe((Widget)control);
            Binding binding = this.getDataBindingContext().bindValue((IObservableValue)observe, this.getModelValue(), this.withPreSetValidation(new UpdateValueStrategy()), null);
            return new Binding[]{binding};
        }
        return new Binding[0];
    }

    protected Control createSWTControl(Composite parent) {
        this.base = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.base.setLayout((Layout)layout);
        this.base.setLayoutData((Object)new GridData(4, 4, true, false));
        this.base.setFont(parent.getFont());
        this.text = this.createText(this.base);
        this.button = this.createButton(this.base);
        return this.text;
    }

    protected Text createText(Composite parent) {
        Text value = new Text(parent, 2048);
        value.setLayoutData((Object)new GridData(4, 4, true, true));
        value.setText(this.getCurrentValue());
        value.setEditable(false);
        return value;
    }

    protected Button createButton(Composite parent) {
        Button edit = new Button(parent, 8);
        edit.setText(WorkbenchEmfformsMessages.TextWithButtonRenderer_button_edit);
        edit.setImage(this.locImages.getImage("IMG_TOOL_EDIT"));
        edit.setLayoutData((Object)new GridData(4, 4, false, false));
        edit.setEnabled(!((VControl)this.getVElement()).isEffectivelyReadonly());
        return edit;
    }

    protected void dispose() {
        if (this.base != null && !this.base.isDisposed()) {
            Control[] controlArray = this.base.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (control != null) {
                    control.dispose();
                }
                ++n2;
            }
        }
        super.dispose();
    }

    protected String getCurrentValue() {
        try {
            Object value = this.getModelValue().getValue();
            if (value instanceof String) {
                return (String)value;
            }
        }
        catch (DatabindingFailedException e) {
            this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)e));
        }
        return this.getUnsetText();
    }

    protected void setValidationColor(Control control, Color validationColor) {
        if (control instanceof Text) {
            Text textControl = (Text)control;
            if (textControl.getText().isEmpty()) {
                control.setBackground(this.licensingColors.getColor("COLOR_VALIDATION_ERROR"));
            } else {
                control.setBackground(this.licensingColors.getColor("COLOR_VALIDATION_OK"));
            }
        }
    }
}

