/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.base.condition;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.passage.lbc.base.BaseComponent;
import org.eclipse.passage.lbc.runtime.LicensingConditionStorage;
import org.eclipse.passage.lic.runtime.LicensingConfiguration;
import org.eclipse.passage.lic.runtime.conditions.ConditionMiner;
import org.eclipse.passage.lic.runtime.conditions.LicensingCondition;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.log.LoggerFactory;

@Component
public class ServerConditionsMiner
extends BaseComponent
implements ConditionMiner {
    private final List<LicensingConditionStorage> conditionStorages = new ArrayList<LicensingConditionStorage>();

    public boolean checkProductById(String productId) {
        return false;
    }

    @Override
    @Reference
    protected void bindLogger(LoggerFactory loggerFactory) {
        super.bindLogger(loggerFactory);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE)
    public void bindLicensingConditionStorage(LicensingConditionStorage conditionStorage) {
        this.logger.debug(conditionStorage.getClass().getName());
        if (conditionStorage != null && !this.conditionStorages.contains(conditionStorage)) {
            this.conditionStorages.add(conditionStorage);
        }
    }

    public void unbindLicensingConditionStorage(LicensingConditionStorage conditionStorage) {
        this.logger.debug(conditionStorage.getClass().getName());
        if (conditionStorage != null && this.conditionStorages.contains(conditionStorage)) {
            this.conditionStorages.remove(conditionStorage);
        }
    }

    public Iterable<LicensingCondition> extractLicensingConditions(LicensingConfiguration configuration) {
        ArrayList<LicensingCondition> result = new ArrayList<LicensingCondition>();
        if (configuration == null) {
            this.logger.error("Licensing configuration not defined");
            return result;
        }
        String productIdentifier = configuration.getProductIdentifier();
        String productVersion = configuration.getProductVersion();
        if (productIdentifier == null || productIdentifier.isEmpty()) {
            this.logger.error("Product identifier not defined");
            return result;
        }
        if (productVersion == null || productVersion.isEmpty()) {
            this.logger.error("Product version not defined");
            return result;
        }
        for (LicensingConditionStorage storage : this.conditionStorages) {
            result.addAll(storage.getLicensingCondition(productIdentifier, productVersion));
        }
        return result;
    }
}

