/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.equinox.restrictions;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.base.restrictions.RestrictionVerdicts;
import org.eclipse.passage.lic.equinox.ApplicationConfigurations;
import org.eclipse.passage.lic.equinox.LicensingEquinox;
import org.eclipse.passage.lic.runtime.LicensingConfiguration;
import org.eclipse.passage.lic.runtime.inspector.FeatureCase;
import org.eclipse.passage.lic.runtime.inspector.FeatureInspector;
import org.eclipse.passage.lic.runtime.requirements.LicensingRequirement;
import org.eclipse.passage.lic.runtime.restrictions.RestrictionVerdict;

public class EquinoxRestrictions {
    public static Iterable<RestrictionVerdict> getFeatureVerdicts(String ... featureIds) {
        FeatureInspector featureInspector = LicensingEquinox.getFeatureInspector();
        if (featureInspector == null) {
            LicensingConfiguration configuration = ApplicationConfigurations.getLicensingConfiguration();
            if (featureIds.length == 0) {
                String id = configuration.getProductIdentifier();
                return Collections.singletonList(RestrictionVerdicts.createConfigurationError((LicensingConfiguration)configuration, (String)id));
            }
            ArrayList<RestrictionVerdict> errors = new ArrayList<RestrictionVerdict>();
            String[] stringArray = featureIds;
            int n = featureIds.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                errors.add((RestrictionVerdict)RestrictionVerdicts.createConfigurationError((LicensingConfiguration)configuration, (String)id));
                ++n2;
            }
            return errors;
        }
        Throwable throwable = null;
        Object var3_7 = null;
        try (FeatureCase inspection = featureInspector.inspectFeatures(featureIds);){
            return inspection.getRestrictions();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static IStatus getRestrictionStatus(Iterable<RestrictionVerdict> verdicts, String featureName) {
        String pluginId = "org.eclipse.passage.lic.equinox";
        if (!verdicts.iterator().hasNext()) {
            String message = NLS.bind((String)"Feature \"{0}\" is licensed properly", (Object)featureName);
            return new Status(0, pluginId, message);
        }
        String title = "Issues with licensing";
        MultiStatus status = new MultiStatus(pluginId, 500, title, null);
        for (RestrictionVerdict verdict : verdicts) {
            LicensingRequirement requirement = verdict.getLicensingRequirement();
            if (requirement != null) {
                featureName = requirement.getFeatureName();
            }
            String message = NLS.bind((String)"Feature \"{0}\" is not licensed properly", (Object)featureName);
            status.add((IStatus)new Status(4, pluginId, message));
        }
        return status;
    }
}

