/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.access;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.passage.lic.base.LicensingResults;
import org.eclipse.passage.lic.base.SystemReporter;
import org.eclipse.passage.lic.base.conditions.BaseConditionMinerRegistry;
import org.eclipse.passage.lic.base.conditions.LicensingConditions;
import org.eclipse.passage.lic.base.requirements.LicensingRequirements;
import org.eclipse.passage.lic.base.restrictions.BaseRestrictionVerdict;
import org.eclipse.passage.lic.base.restrictions.RestrictionVerdicts;
import org.eclipse.passage.lic.runtime.LicensingConfiguration;
import org.eclipse.passage.lic.runtime.LicensingException;
import org.eclipse.passage.lic.runtime.LicensingReporter;
import org.eclipse.passage.lic.runtime.LicensingResult;
import org.eclipse.passage.lic.runtime.access.AccessManager;
import org.eclipse.passage.lic.runtime.access.FeaturePermission;
import org.eclipse.passage.lic.runtime.access.PermissionEmitter;
import org.eclipse.passage.lic.runtime.access.PermissionExaminer;
import org.eclipse.passage.lic.runtime.conditions.ConditionMiner;
import org.eclipse.passage.lic.runtime.conditions.ConditionMinerRegistry;
import org.eclipse.passage.lic.runtime.conditions.LicensingCondition;
import org.eclipse.passage.lic.runtime.requirements.LicensingRequirement;
import org.eclipse.passage.lic.runtime.requirements.RequirementResolver;
import org.eclipse.passage.lic.runtime.restrictions.RestrictionExecutor;
import org.eclipse.passage.lic.runtime.restrictions.RestrictionVerdict;

public class BaseAccessManager
implements AccessManager {
    private LicensingReporter licensingReporter = SystemReporter.INSTANCE;
    private final List<RequirementResolver> requirementResolvers = new ArrayList<RequirementResolver>();
    private ConditionMinerRegistry conditionMinerRegistry = new BaseConditionMinerRegistry();
    private final Map<String, PermissionEmitter> permissionEmitters = new HashMap<String, PermissionEmitter>();
    private final List<RestrictionExecutor> restrictionExecutors = new ArrayList<RestrictionExecutor>();
    private PermissionExaminer examiner;

    public void bindLicensingReporter(LicensingReporter reporter) {
        this.licensingReporter = reporter;
    }

    public void unbindLicensingReporter(LicensingReporter reporter) {
        if (this.licensingReporter == reporter) {
            this.licensingReporter = SystemReporter.INSTANCE;
        }
    }

    public LicensingReporter getLicensingReporter() {
        return this.licensingReporter;
    }

    public void bindRequirementResolver(RequirementResolver requirementResolver) {
        this.requirementResolvers.add(requirementResolver);
    }

    public void unbindRequirementResolver(RequirementResolver configurationResolver) {
        this.requirementResolvers.remove(configurationResolver);
    }

    public void bindConditionMinerRegistry(ConditionMinerRegistry registry) {
        this.conditionMinerRegistry = registry;
    }

    public void unbindConditionMinerRegistry(ConditionMinerRegistry registry) {
        if (this.conditionMinerRegistry == registry) {
            this.conditionMinerRegistry = null;
        }
    }

    public void bindPermissionEmitter(PermissionEmitter permissionEmitter, Map<String, Object> properties) {
        Object conditionType = properties.get("licensing.condition.type.id");
        String type = String.valueOf(conditionType);
        this.permissionEmitters.put(type, permissionEmitter);
    }

    public void unbindPermissionEmitter(PermissionEmitter permissionEmitter, Map<String, Object> properties) {
        Object conditionType = properties.get("licensing.condition.type.id");
        String type = String.valueOf(conditionType);
        this.permissionEmitters.remove(type, permissionEmitter);
    }

    public void bindPermissionExaminer(PermissionExaminer permissionExaminer) {
        this.examiner = permissionExaminer;
    }

    public void unbindPermissionExaminer(PermissionExaminer permissionExaminer) {
        this.examiner = permissionExaminer == this.examiner ? null : null;
    }

    public void bindRestrictionExecutor(RestrictionExecutor restrictionExecutor) {
        this.restrictionExecutors.add(restrictionExecutor);
    }

    public void unbindRestrictionExecutor(RestrictionExecutor restrictionExecutor) {
        this.restrictionExecutors.remove(restrictionExecutor);
    }

    public LicensingResult executeAccessRestrictions(LicensingConfiguration configuration) {
        Iterable<LicensingRequirement> requirements = this.resolveRequirements(configuration);
        Iterable<LicensingCondition> conditions = this.extractConditions(configuration);
        Iterable<FeaturePermission> permissions = this.evaluateConditions(configuration, conditions);
        Iterable<RestrictionVerdict> verdicts = this.examinePermissons(configuration, requirements, permissions);
        return this.executeRestrictions(configuration, verdicts);
    }

    public Iterable<LicensingRequirement> resolveRequirements(LicensingConfiguration configuration) {
        String featureId;
        ArrayList<LicensingRequirement> result = new ArrayList<LicensingRequirement>();
        String source = this.getClass().getName();
        if (configuration == null) {
            featureId = "org.eclipse.passage.lic.runtime.invalid";
            result.add(LicensingRequirements.createConfigurationError(featureId, source));
        } else if (this.requirementResolvers.isEmpty()) {
            featureId = configuration.getProductIdentifier();
            result.add(LicensingRequirements.createConfigurationError(featureId, source));
        } else {
            for (RequirementResolver configurationResolver : this.requirementResolvers) {
                Iterable requirements = configurationResolver.resolveLicensingRequirements(configuration);
                for (LicensingRequirement requirement : requirements) {
                    result.add(requirement);
                }
            }
        }
        List<LicensingRequirement> unmodifiable = Collections.unmodifiableList(result);
        this.licensingReporter.postResult(LicensingResults.createEvent("org/eclipse/passage/lic/runtime/RequirementEvents/requirementsResolved", unmodifiable));
        return unmodifiable;
    }

    public Iterable<LicensingCondition> extractConditions(LicensingConfiguration configuration) {
        ArrayList<LicensingCondition> mined = new ArrayList<LicensingCondition>();
        Iterable conditionMiners = this.conditionMinerRegistry.getConditionMiners();
        ArrayList<LicensingResult> errors = new ArrayList<LicensingResult>();
        for (ConditionMiner conditionMiner : conditionMiners) {
            Iterable conditions = conditionMiner.extractLicensingConditions(configuration);
            if (conditions == null) {
                String source = conditionMiner.getClass().getName();
                String message = "Invalid condition miner";
                LicensingResult error = LicensingResults.createError(message, source, (Throwable)new NullPointerException());
                errors.add(error);
                continue;
            }
            for (LicensingCondition condition : conditions) {
                mined.add(condition);
            }
        }
        List<LicensingCondition> unmodifiable = Collections.unmodifiableList(mined);
        this.licensingReporter.postResult(LicensingResults.createEvent("org/eclipse/passage/lic/runtime/AccessEvents/conditionsExtracted", unmodifiable));
        return unmodifiable;
    }

    public Iterable<FeaturePermission> evaluateConditions(LicensingConfiguration configuration, Iterable<LicensingCondition> conditions) {
        ArrayList<FeaturePermission> result = new ArrayList<FeaturePermission>();
        String source = this.getClass().getName();
        if (conditions == null) {
            String message = "Evaluation rejected for invalid conditions";
            LicensingResult error = LicensingResults.createError(message, source, (Throwable)new IllegalArgumentException());
            this.licensingReporter.logResult(error);
            List<FeaturePermission> empty = Collections.emptyList();
            this.licensingReporter.postResult(LicensingResults.createEvent("org/eclipse/passage/lic/runtime/AccessEvents/conditionsEvaluated", empty, error));
            return empty;
        }
        HashMap<String, List> map = new HashMap<String, List>();
        ArrayList<LicensingCondition> invalid = new ArrayList<LicensingCondition>();
        for (LicensingCondition condition : conditions) {
            if (condition == null) {
                String message = "Evaluation rejected for invalid condition";
                LicensingResult error = LicensingResults.createError(message, source, (Throwable)new NullPointerException());
                this.licensingReporter.logResult(error);
                continue;
            }
            LicensingResult validate = LicensingConditions.validate(condition, source);
            if (validate.getSeverity() == 0) {
                String type = condition.getConditionType();
                List list = map.computeIfAbsent(type, key -> new ArrayList());
                list.add(condition);
                continue;
            }
            this.licensingReporter.logResult(validate);
            invalid.add(condition);
        }
        Set types = map.keySet();
        for (String type : types) {
            PermissionEmitter emitter = this.permissionEmitters.get(type);
            if (emitter == null) {
                String message = String.format("No permission emitter available for type %s", type);
                LicensingResult error = LicensingResults.createError(message, source, (Throwable)new NullPointerException());
                this.licensingReporter.logResult(error);
                continue;
            }
            List mappedConditions = (List)map.get(type);
            try {
                Iterable permissions = emitter.emitPermissions(configuration, (Iterable)mappedConditions);
                for (FeaturePermission permission : permissions) {
                    result.add(permission);
                }
            }
            catch (LicensingException e) {
                LicensingResult error = e.getResult();
                this.licensingReporter.logResult(error);
                this.licensingReporter.postResult(LicensingResults.createEvent("org/eclipse/passage/lic/runtime/ConditionEvents/conditionsNotValid", mappedConditions, error));
            }
        }
        List<FeaturePermission> unmodifiable = Collections.unmodifiableList(result);
        this.licensingReporter.postResult(LicensingResults.createEvent("org/eclipse/passage/lic/runtime/AccessEvents/conditionsEvaluated", unmodifiable));
        return unmodifiable;
    }

    public Iterable<RestrictionVerdict> examinePermissons(LicensingConfiguration configuration, Iterable<LicensingRequirement> requirements, Iterable<FeaturePermission> permissions) {
        String source = this.getClass().getName();
        if (configuration == null) {
            String message = "Invalid configuration";
            LicensingResult error = LicensingResults.createError(message, source, (Throwable)new NullPointerException());
            this.licensingReporter.logResult(error);
            List<RestrictionVerdict> examined = Collections.emptyList();
            this.licensingReporter.postResult(LicensingResults.createEvent("org/eclipse/passage/lic/runtime/AccessEvents/permissionsExamined", examined));
            return examined;
        }
        if (requirements == null) {
            String message = "Invalid configuration requirements";
            LicensingResult error = LicensingResults.createError(message, source, (Throwable)new NullPointerException());
            this.licensingReporter.logResult(error);
            List<RestrictionVerdict> examined = Collections.emptyList();
            this.licensingReporter.postResult(LicensingResults.createEvent("org/eclipse/passage/lic/runtime/AccessEvents/permissionsExamined", examined));
            return examined;
        }
        if (this.examiner == null) {
            String message = String.format("No permission examiner defined, rejecting all %s", requirements);
            LicensingResult error = LicensingResults.createError(message, source, (Throwable)new NullPointerException());
            this.licensingReporter.logResult(error);
            ArrayList<RestrictionVerdict> verdicts = new ArrayList<RestrictionVerdict>();
            for (LicensingRequirement requirement : requirements) {
                if (requirement == null) {
                    String message2 = "Invalid configuration requirement ignored";
                    LicensingResult error2 = LicensingResults.createError(message2, source, (Throwable)new NullPointerException());
                    this.licensingReporter.logResult(error2);
                    continue;
                }
                BaseRestrictionVerdict verdict = RestrictionVerdicts.createError(configuration, requirement, 500);
                verdicts.add(verdict);
            }
            this.licensingReporter.postResult(LicensingResults.createEvent("org/eclipse/passage/lic/runtime/AccessEvents/permissionsExamined", Collections.unmodifiableList(verdicts)));
            return verdicts;
        }
        Iterable examined = this.examiner.examine(configuration, requirements, permissions);
        this.licensingReporter.postResult(LicensingResults.createEvent("org/eclipse/passage/lic/runtime/AccessEvents/permissionsExamined", examined));
        return examined;
    }

    public LicensingResult executeRestrictions(LicensingConfiguration configuration, Iterable<RestrictionVerdict> restrictions) {
        String source = this.getClass().getName();
        String task = "Executing restrinctions";
        ArrayList<LicensingResult> errors = new ArrayList<LicensingResult>();
        for (RestrictionExecutor executor : this.restrictionExecutors) {
            try {
                executor.execute(restrictions);
            }
            catch (Exception e) {
                String message = String.format("%s failed to execute %s", executor, restrictions);
                LicensingResult error = LicensingResults.createError(message, source, (Throwable)e);
                errors.add(error);
            }
        }
        this.licensingReporter.postResult(LicensingResults.createEvent("org/eclipse/passage/lic/runtime/AccessEvents/restrictionsExecuted", restrictions));
        if (errors.isEmpty()) {
            return LicensingResults.createOK(task, source);
        }
        return LicensingResults.createError(task, source, errors);
    }
}

