/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.base.condition;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.passage.lbc.base.BaseComponent;
import org.eclipse.passage.lbc.base.condition.ServerConditionsArbitr;
import org.eclipse.passage.lbc.runtime.LicensingConditionStorage;
import org.eclipse.passage.lic.equinox.io.EquinoxPaths;
import org.eclipse.passage.lic.runtime.conditions.ConditionTransport;
import org.eclipse.passage.lic.runtime.conditions.LicensingCondition;
import org.eclipse.passage.lic.runtime.io.StreamCodec;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.log.LoggerFactory;

@Component
public class ServerConditionsStorage
extends BaseComponent
implements LicensingConditionStorage {
    private static final String TRANSPORT_NOT_FOUND = "Transport for license descriptors not found";
    private EnvironmentInfo environmentInfo;
    private StreamCodec streamCodec;
    private String CONDITION_EXTENSION = ".licen";
    private ConditionTransport conditionTransport;
    private ServerConditionsArbitr conditionArbitr;

    @Override
    @Reference
    protected void bindLogger(LoggerFactory loggerFactory) {
        super.bindLogger(loggerFactory);
    }

    @Reference
    public void bindEnvironmentInfo(EnvironmentInfo environmentInfo) {
        this.environmentInfo = environmentInfo;
    }

    public void unbindEnvironmentInfo(EnvironmentInfo environmentInfo) {
        this.environmentInfo = null;
    }

    @Reference
    public void bindStreamCodec(StreamCodec codec) {
        this.streamCodec = codec;
    }

    public void unbindStreamCodec(StreamCodec codec) {
        this.streamCodec = null;
    }

    public void bindServerConditionsArbitr(ServerConditionsArbitr conditionArbitr) {
        this.conditionArbitr = conditionArbitr;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE)
    public void bindConditionTransport(ConditionTransport transport, Map<String, Object> properties) {
        String contentType = String.valueOf(properties.get("licensing.content.type"));
        if ("application/xml".equals(contentType)) {
            this.conditionTransport = transport;
        }
    }

    public void unbindConditionTransport(ConditionTransport transport, Map<String, Object> properties) {
        String contentType = String.valueOf(properties.get("licensing.content.type"));
        if ("application/xml".equals(contentType)) {
            this.conditionTransport = null;
        }
    }

    public List<LicensingCondition> getLicensingCondition(final String productId, final String productVersion) {
        ArrayList<LicensingCondition> descriptors = new ArrayList<LicensingCondition>();
        Path areaPath = EquinoxPaths.resolveInstallBasePath();
        if (!Files.isDirectory(areaPath, new LinkOption[0])) {
            return descriptors;
        }
        final HashMap producKeyMap2TokenPath = new HashMap();
        try {
            Files.walkFileTree(areaPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path filePath, BasicFileAttributes attrs) throws IOException {
                    if (filePath.toString().toLowerCase().endsWith(ServerConditionsStorage.this.CONDITION_EXTENSION)) {
                        Path parentFolderVersion = filePath.getParent();
                        Path parentFolderProduct = parentFolderVersion.getParent();
                        String productIdFileName = parentFolderProduct.getFileName().toString();
                        String productVersionFileName = parentFolderVersion.getFileName().toString();
                        if (productId.equals(productIdFileName) && productVersion.equals(productVersionFileName)) {
                            String productKeyFileName = String.format("%s_%s.pub", productId, productVersion);
                            File productVersionFile = parentFolderVersion.toFile();
                            File[] fileArray = productVersionFile.listFiles();
                            int n = fileArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                File file = fileArray[n2];
                                if (productKeyFileName.equals(file.getName()) && !producKeyMap2TokenPath.containsKey(filePath)) {
                                    producKeyMap2TokenPath.put(filePath, file);
                                    break;
                                }
                                ++n2;
                            }
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Object)e);
        }
        for (Map.Entry productEntry : producKeyMap2TokenPath.entrySet()) {
            File productConditionFile = ((Path)productEntry.getKey()).toFile();
            File productTokenFile = (File)productEntry.getValue();
            if (productTokenFile == null || productConditionFile == null) {
                this.logger.error("Product Installation Token(public key) or Condition(license) not found");
                return descriptors;
            }
            ByteArrayOutputStream decodedTokenStream = new ByteArrayOutputStream();
            try {
                Throwable throwable = null;
                Object var12_15 = null;
                try {
                    FileInputStream productTokenStream = new FileInputStream(productTokenFile);
                    try {
                        try (FileInputStream productConditionStream = new FileInputStream(productConditionFile);){
                            this.streamCodec.decodeStream((InputStream)productConditionStream, (OutputStream)decodedTokenStream, (InputStream)productTokenStream, null);
                            byte[] byteArray = decodedTokenStream.toByteArray();
                            Throwable throwable2 = null;
                            Object var17_23 = null;
                            try (ByteArrayInputStream input = new ByteArrayInputStream(byteArray);){
                                if (this.conditionTransport != null) {
                                    Iterable extractedConditions = this.conditionTransport.readConditions((InputStream)input);
                                    for (LicensingCondition condition : extractedConditions) {
                                        if (!this.conditionArbitr.addConditionToReserv(condition)) continue;
                                        descriptors.add(condition);
                                    }
                                } else {
                                    this.logger.error(TRANSPORT_NOT_FOUND);
                                }
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                        }
                        if (productTokenStream == null) continue;
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        if (productTokenStream != null) {
                            productTokenStream.close();
                        }
                        throw throwable;
                    }
                    productTokenStream.close();
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Object)e);
            }
        }
        return descriptors;
    }
}

