/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.hooks;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.equinox.service.weaving.CacheEntry;
import org.eclipse.equinox.weaving.adaptors.Debug;
import org.eclipse.equinox.weaving.adaptors.IWeavingAdaptor;
import org.eclipse.equinox.weaving.hooks.AbstractWeavingBundleFile;
import org.eclipse.equinox.weaving.hooks.BundleAdaptorProvider;
import org.eclipse.equinox.weaving.hooks.CachedClassBundleEntry;
import org.eclipse.equinox.weaving.hooks.CachedGeneratedClassBundleEntry;
import org.eclipse.equinox.weaving.hooks.WeavingBundleEntry;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.BundleFile;

public class WeavingBundleFile
extends AbstractWeavingBundleFile {
    private final URL url;

    public WeavingBundleFile(BundleAdaptorProvider adaptorProvider, BundleFile bundleFile) {
        super(adaptorProvider, bundleFile);
        try {
            this.url = this.delegate.getBaseFile().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unexpected error getting bundle file URL.", e);
        }
    }

    public BundleEntry getEntry(String path) {
        if (Debug.DEBUG_BUNDLE) {
            Debug.println("> AspectJBundleFile.getEntry() path=" + path + ", url=" + this.url);
        }
        BundleEntry entry = this.delegate.getEntry(path);
        if (path.endsWith(".class") && entry != null) {
            int offset = path.lastIndexOf(46);
            String name = path.substring(0, offset).replace('/', '.');
            IWeavingAdaptor adaptor = this.getAdaptor();
            if (adaptor != null) {
                CacheEntry cacheEntry = adaptor.findClass(name, this.url);
                if (cacheEntry == null) {
                    entry = new WeavingBundleEntry(adaptor, entry, this.url, false);
                    if (Debug.DEBUG_BUNDLE) {
                        Debug.println("- AspectJBundleFile.getEntry() path=" + path + ", entry=" + entry);
                    }
                } else {
                    entry = cacheEntry.getCachedBytes() != null ? new CachedClassBundleEntry(adaptor, entry, path, cacheEntry.getCachedBytes(), this.url) : new WeavingBundleEntry(adaptor, entry, this.url, cacheEntry.dontWeave());
                }
            }
        } else if (path.endsWith(".class") && entry == null) {
            CacheEntry cacheEntry;
            int offset = path.lastIndexOf(46);
            String name = path.substring(0, offset).replace('/', '.');
            IWeavingAdaptor adaptor = this.getAdaptor();
            if (adaptor != null && (cacheEntry = adaptor.findClass(name, this.url)) != null && cacheEntry.getCachedBytes() != null) {
                entry = new CachedGeneratedClassBundleEntry(adaptor, path, cacheEntry.getCachedBytes(), this.url);
            }
        }
        if (Debug.DEBUG_BUNDLE) {
            Debug.println("< AspectJBundleFile.getEntry() entry=" + entry);
        }
        return entry;
    }
}

