/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.base;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.passage.lbc.api.BackendActionExecutor;
import org.eclipse.passage.lbc.api.BackendRequestDispatcher;
import org.eclipse.passage.lbc.internal.base.i18n.BaseMessages;
import org.eclipse.passage.lic.api.LicensingReporter;
import org.eclipse.passage.lic.api.LicensingResult;
import org.eclipse.passage.lic.base.LicensingResults;
import org.eclipse.passage.lic.base.SystemReporter;

public class BaseRequestDispatcher
implements BackendRequestDispatcher {
    private LicensingReporter licensingReporter = SystemReporter.INSTANCE;
    private String roleId;
    private static Map<String, BackendActionExecutor> actionExecutors = new HashMap<String, BackendActionExecutor>();

    protected void activate(Map<String, Object> properties) {
        this.roleId = String.valueOf(properties.get("role"));
    }

    protected void bindLicensingReporter(LicensingReporter reporter) {
        this.licensingReporter = reporter;
    }

    protected void unbindLicensingReporter(LicensingReporter reporter) {
        if (this.licensingReporter == reporter) {
            this.licensingReporter = SystemReporter.INSTANCE;
        }
    }

    protected void bindBackendActionExecutor(BackendActionExecutor executor, Map<String, Object> properties) {
        String actionId = String.valueOf(properties.get("action"));
        actionExecutors.put(actionId, executor);
    }

    protected void unbindBackendActionExecutor(BackendActionExecutor executor, Map<String, Object> properties) {
        String actionId = String.valueOf(properties.get("action"));
        actionExecutors.remove(actionId, executor);
    }

    public boolean canDispatchRequest(HttpServletRequest baseRequest) {
        String requestRole = baseRequest.getParameter("role");
        return Objects.equals(this.roleId, requestRole);
    }

    public void dispatchRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String actionId = request.getParameter("action");
        BackendActionExecutor requestAction = actionExecutors.get(actionId);
        if (requestAction != null) {
            LicensingResult execution = requestAction.executeAction(request, response);
            this.licensingReporter.logResult(execution);
        } else {
            String message = String.format(BaseMessages.BaseRequestDispatcher_e_executor_not_available, requestAction);
            this.licensingReporter.logResult(LicensingResults.createError((String)message, (String)this.getClass().getName()));
            response.sendError(417, message);
        }
    }
}

