/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.passage.lic.internal.api.registry.RuntimeRegistry;
import org.eclipse.passage.lic.internal.api.registry.Service;
import org.eclipse.passage.lic.internal.api.registry.ServiceId;
import org.eclipse.passage.lic.internal.base.i18n.BaseMessages;

public final class BaseRuntimeRegistry<I extends ServiceId, S extends Service<I>>
implements RuntimeRegistry<I, S> {
    private final Map<I, S> services;
    private final Consumer<String> handler;

    public BaseRuntimeRegistry(Map<I, S> init, Consumer<String> handler) {
        this.services = init;
        this.handler = handler;
    }

    public BaseRuntimeRegistry() {
        this(new HashMap(), System.err::println);
    }

    public BaseRuntimeRegistry(Map<I, S> init) {
        this(init, System.err::println);
    }

    public BaseRuntimeRegistry(Consumer<String> handler) {
        this(new HashMap(), handler);
    }

    public void register(S service) {
        Objects.requireNonNull(service);
        this.checkOverride(service);
        this.services.put(service.id(), service);
    }

    public void unregister(S service) {
        this.checkAbsent(service);
        this.services.remove(service.id());
    }

    public boolean hasService(I id) {
        return this.services.containsKey(id);
    }

    public S service(I id) {
        if (!this.hasService(id)) {
            throw new IllegalStateException(String.format(BaseMessages.getString("Registry.retrieve_absent_exception"), id));
        }
        return (S)((Service)this.services.get(id));
    }

    public Collection<S> services() {
        return this.services.values();
    }

    private void checkOverride(S service) {
        if (!this.hasService(service.id())) {
            return;
        }
        this.handler.accept(String.format(BaseMessages.getString("RuntimeRegistry.register_override"), service.id(), this.service(service.id()), service));
    }

    private void checkAbsent(S service) {
        if (this.hasService(service.id())) {
            return;
        }
        this.handler.accept(String.format(BaseMessages.getString("RuntimeRegistry.unregister_absent"), service));
    }
}

