/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.function.Supplier;
import org.eclipse.passage.lbc.internal.base.i18n.BaseMessages;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.io.KeyKeeper;
import org.eclipse.passage.lic.internal.base.io.FileNameFromLicensedProduct;
import org.eclipse.passage.lic.internal.base.io.LicensingFolder;
import org.eclipse.passage.lic.internal.base.io.PassageFileExtension;
import org.eclipse.passage.lic.internal.base.io.UserHomePath;

public class ServerKeyKeeper
implements KeyKeeper {
    private final Supplier<LicensedProduct> product;

    public ServerKeyKeeper(Supplier<LicensedProduct> product) {
        this.product = product;
    }

    public LicensedProduct id() {
        return this.product.get();
    }

    public InputStream productPublicKey() throws LicensingException {
        String path = new LicensingFolder((Supplier)new UserHomePath()).get().resolve(this.keyFile()).toString();
        try {
            return new FileInputStream(path);
        }
        catch (Exception e) {
            throw new LicensingException(BaseMessages.ServerKeyKeeper_input_stream_error);
        }
    }

    private String keyFile() {
        return new FileNameFromLicensedProduct(this.product.get(), (PassageFileExtension)new PassageFileExtension.PublicKey()).get();
    }
}

