/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base.persistence;

import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.passage.lbc.internal.api.persistence.BoundLicense;
import org.eclipse.passage.lbc.internal.base.persistence.LockFolder;
import org.eclipse.passage.lic.internal.api.conditions.Condition;

public final class LockFile
implements Supplier<Path> {
    private final Supplier<Path> folder;
    private final String identifier;

    private LockFile(Supplier<Path> folder, String identifier) {
        Objects.requireNonNull(folder, "LockFile::folder");
        Objects.requireNonNull(identifier, "LockFile::identifier");
        this.folder = folder;
        this.identifier = identifier;
    }

    public LockFile(Supplier<Path> folder, BoundLicense license) {
        this(folder, (String)((Optional)license.identifier().get()).get());
    }

    public LockFile(Supplier<Path> folder, Condition license) {
        this(folder, license.identifier());
    }

    public LockFile(BoundLicense license) {
        this((Supplier<Path>)new LockFolder(), license);
    }

    public LockFile(Condition license) {
        this((Supplier<Path>)new LockFolder(), license);
    }

    @Override
    public Path get() {
        return this.folder.get().resolve(this.identifier);
    }
}

