/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.oshi;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.passage.lic.internal.api.inspection.EnvironmentProperty;
import org.eclipse.passage.lic.internal.base.inspection.hardware.Disk;
import org.eclipse.passage.lic.internal.oshi.State;

final class GlanceOfState
implements Supplier<String> {
    private final State state;

    GlanceOfState(State state) {
        Objects.requireNonNull(state);
        this.state = state;
    }

    @Override
    public String get() {
        StringBuilder out = new StringBuilder();
        this.state.properties().stream().collect(Collectors.groupingBy(EnvironmentProperty::family)).entrySet().stream().forEach(e -> this.appendFamily((String)e.getKey(), (List)e.getValue(), out));
        IntStream.range(0, this.state.disksAmount()).forEach(no -> this.appendDisk(no, out));
        return out.toString();
    }

    private void appendDisk(int no, StringBuilder out) {
        out.append(new Disk.Model().family()).append(" #").append(no).append("\r\n");
        this.state.diskProperties(no).stream().forEach(p -> {
            StringBuilder stringBuilder2 = this.appendProperty((EnvironmentProperty)p, this.state.diskValue(no, (EnvironmentProperty)p), out);
        });
    }

    private void appendFamily(String family, List<EnvironmentProperty> properties, StringBuilder out) {
        out.append(family).append("\r\n");
        properties.stream().forEach(p -> {
            StringBuilder stringBuilder2 = this.appendProperty((EnvironmentProperty)p, this.state.value((EnvironmentProperty)p), out);
        });
    }

    private StringBuilder appendProperty(EnvironmentProperty property, String value, StringBuilder out) {
        out.append("\t").append(property.name()).append(": ").append(value).append("\r\n");
        return out;
    }
}

