/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.AbstractMinimalModel;
import org.sat4j.tools.SolutionFoundListener;

public class Minimal4InclusionModel
extends AbstractMinimalModel {
    private static final long serialVersionUID = 1L;
    private int[] prevfullmodel;

    public Minimal4InclusionModel(ISolver solver, IVecInt p, SolutionFoundListener modelListener) {
        super(solver, p, modelListener);
    }

    public Minimal4InclusionModel(ISolver solver, IVecInt p) {
        this(solver, p, SolutionFoundListener.VOID);
    }

    public Minimal4InclusionModel(ISolver solver) {
        this(solver, Minimal4InclusionModel.negativeLiterals(solver), SolutionFoundListener.VOID);
    }

    public int[] model() {
        int[] prevmodel = null;
        VecInt vec = new VecInt();
        VecInt cube = new VecInt();
        IConstr prevConstr = null;
        try {
            do {
                this.prevfullmodel = super.modelWithInternalVariables();
                prevmodel = super.model();
                this.modelListener.onSolutionFound(prevmodel);
                vec.clear();
                cube.clear();
                int[] nArray = this.prevfullmodel;
                int n = this.prevfullmodel.length;
                int n2 = 0;
                while (n2 < n) {
                    int q = nArray[n2];
                    if (this.pLiterals.contains(q)) {
                        vec.push(-q);
                    } else if (this.pLiterals.contains(-q)) {
                        cube.push(q);
                    }
                    ++n2;
                }
                if (prevConstr != null) {
                    this.removeSubsumedConstr(prevConstr);
                }
                prevConstr = this.addBlockingClause(vec);
            } while (this.isSatisfiable(cube));
        }
        catch (TimeoutException timeoutException) {
            throw new IllegalStateException("Solver timed out");
        }
        catch (ContradictionException contradictionException) {}
        return prevmodel;
    }

    public int[] modelWithInternalVariables() {
        this.model();
        return this.prevfullmodel;
    }
}

