/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.equinox;

import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.Passage;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.access.GrantLockAttempt;
import org.eclipse.passage.lic.internal.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.internal.base.access.Access;
import org.eclipse.passage.lic.internal.equinox.FrameworkAware;
import org.eclipse.passage.lic.internal.equinox.SuppliedFrameworkAware;

public final class EquinoxPassage
implements Passage {
    private final FrameworkAware<?> delegate;

    public EquinoxPassage() {
        this(new SuppliedFrameworkAware());
    }

    public EquinoxPassage(FrameworkAware<?> delegate) {
        this.delegate = delegate;
    }

    public boolean canUse(String feature) {
        return this.delegate.withFramework(framework -> new Access(framework).canUse(feature)).orElse(Boolean.FALSE);
    }

    public ServiceInvocationResult<GrantLockAttempt> acquireLicense(String feature) {
        return this.delegate.withFrameworkService(framework -> new Access(framework).acquire(feature));
    }

    public ServiceInvocationResult<Boolean> releaseLicense(GrantLockAttempt lock) {
        return this.delegate.withFrameworkService(framework -> new Access(framework).release(lock));
    }

    public ServiceInvocationResult<LicensedProduct> product() {
        return this.delegate.withFrameworkService(framework -> new BaseServiceInvocationResult((Object)framework.product()));
    }
}

