/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.oshi;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.inspection.EnvironmentProperty;
import org.eclipse.passage.lic.internal.base.inspection.hardware.BaseBoard;
import org.eclipse.passage.lic.internal.base.inspection.hardware.Computer;
import org.eclipse.passage.lic.internal.base.inspection.hardware.Cpu;
import org.eclipse.passage.lic.internal.base.inspection.hardware.Firmware;
import org.eclipse.passage.lic.internal.base.inspection.hardware.OS;
import org.eclipse.passage.lic.internal.oshi.EnvironmentProperties;
import org.eclipse.passage.lic.internal.oshi.FragileData;
import org.eclipse.passage.lic.internal.oshi.Swath;
import org.eclipse.passage.lic.internal.oshi.i18n.AssessmentMessages;
import oshi.SystemInfo;
import oshi.hardware.Baseboard;
import oshi.hardware.CentralProcessor;
import oshi.hardware.ComputerSystem;
import oshi.hardware.Firmware;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.OperatingSystem;
import oshi.software.os.OperatingSystemVersion;

final class State {
    private final EnvironmentProperties hardware = new EnvironmentProperties();
    private final List<Swath<?>> swaths = Arrays.asList(new Swath.Disks(), new Swath.Nets());

    State() throws LicensingException {
        this.read();
    }

    boolean hasValue(EnvironmentProperty property, String expected) {
        String regexp = expected.replaceAll("\\*", ".*");
        Optional<Swath> swath = this.swaths.stream().filter(sw -> sw.relates(property.family())).findAny();
        if (swath.isPresent()) {
            return swath.get().hasValue(property, regexp);
        }
        return Optional.ofNullable(this.hardware.get(property)).map(value -> value.matches(regexp)).orElse(false);
    }

    Set<EnvironmentProperty> properties() {
        return this.hardware.all();
    }

    String value(EnvironmentProperty key) {
        return this.hardware.get(key);
    }

    List<Swath<?>> swaths() {
        return this.swaths;
    }

    private void read() throws LicensingException {
        try {
            SystemInfo system = new SystemInfo();
            this.readOS(system.getOperatingSystem());
            this.readHal(system.getHardware());
            this.swaths.forEach(swath -> swath.read(system));
        }
        catch (Throwable e) {
            throw new LicensingException(AssessmentMessages.State_error_reading_hw, e);
        }
    }

    private void readOS(OperatingSystem info) {
        this.hardware.store(() -> ((OperatingSystem)info).getFamily(), (EnvironmentProperty)new OS.Family());
        this.hardware.store(() -> ((OperatingSystem)info).getManufacturer(), (EnvironmentProperty)new OS.Manufacturer());
        this.hardware.store(() -> ((OperatingSystemVersion)info.getVersion()).getVersion(), (EnvironmentProperty)new OS.Version());
        this.hardware.store(() -> ((OperatingSystemVersion)info.getVersion()).getBuildNumber(), (EnvironmentProperty)new OS.BuildNumber());
    }

    private void readHal(HardwareAbstractionLayer hal) {
        this.readPart(() -> ((HardwareAbstractionLayer)hal).getComputerSystem(), this::readSystem);
        this.readPart(() -> ((HardwareAbstractionLayer)hal).getProcessor(), this::readProcessor);
    }

    private void readSystem(ComputerSystem info) {
        this.hardware.store(() -> ((ComputerSystem)info).getManufacturer(), (EnvironmentProperty)new Computer.Manufacturer());
        this.hardware.store(() -> ((ComputerSystem)info).getModel(), (EnvironmentProperty)new Computer.Model());
        this.hardware.store(() -> ((ComputerSystem)info).getSerialNumber(), (EnvironmentProperty)new Computer.Serial());
        this.readPart(() -> ((ComputerSystem)info).getBaseboard(), this::readBaseBoard);
        this.readPart(() -> ((ComputerSystem)info).getFirmware(), this::readFirmware);
    }

    private void readBaseBoard(Baseboard info) {
        this.hardware.store(() -> ((Baseboard)info).getManufacturer(), (EnvironmentProperty)new BaseBoard.Manufacturer());
        this.hardware.store(() -> ((Baseboard)info).getModel(), (EnvironmentProperty)new BaseBoard.Model());
        this.hardware.store(() -> ((Baseboard)info).getVersion(), (EnvironmentProperty)new BaseBoard.Version());
        this.hardware.store(() -> ((Baseboard)info).getSerialNumber(), (EnvironmentProperty)new BaseBoard.Serial());
    }

    private void readFirmware(Firmware info) {
        this.hardware.store(() -> ((Firmware)info).getManufacturer(), (EnvironmentProperty)new Firmware.Manufacturer());
        this.hardware.store(() -> ((Firmware)info).getVersion(), (EnvironmentProperty)new Firmware.Version());
        this.hardware.store(() -> ((Firmware)info).getReleaseDate(), (EnvironmentProperty)new Firmware.ReleaseDate());
        this.hardware.store(() -> ((Firmware)info).getName(), (EnvironmentProperty)new Firmware.Name());
        this.hardware.store(() -> ((Firmware)info).getDescription(), (EnvironmentProperty)new Firmware.Description());
    }

    private void readProcessor(CentralProcessor info) {
        this.hardware.store(() -> ((CentralProcessor)info).getVendor(), (EnvironmentProperty)new Cpu.Vendor());
        this.hardware.store(() -> ((CentralProcessor)info).getFamily(), (EnvironmentProperty)new Cpu.Family());
        this.hardware.store(() -> ((CentralProcessor)info).getModel(), (EnvironmentProperty)new Cpu.Model());
        this.hardware.store(() -> ((CentralProcessor)info).getName(), (EnvironmentProperty)new Cpu.Name());
        this.hardware.store(() -> ((CentralProcessor)info).getProcessorID(), (EnvironmentProperty)new Cpu.ProcessorId());
    }

    private <T> void readPart(Supplier<T> aspect, Consumer<T> read) {
        new FragileData<T>(aspect, read).supply();
    }
}

