/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base.interaction;

import java.nio.file.Path;
import java.util.Collections;
import java.util.Optional;
import org.eclipse.passage.lbc.internal.base.api.FlsGear;
import org.eclipse.passage.lbc.internal.base.api.FlsGearAwre;
import org.eclipse.passage.lic.floating.model.api.FloatingLicensePack;
import org.eclipse.passage.lic.floating.model.api.ProductRef;
import org.eclipse.passage.lic.floating.model.meta.FloatingPackage;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.io.KeyKeeper;
import org.eclipse.passage.lic.internal.base.BaseLicensedProduct;
import org.eclipse.passage.lic.internal.base.InvalidLicensedProduct;
import org.eclipse.passage.lic.internal.base.conditions.mining.DecodedContent;
import org.eclipse.passage.lic.internal.base.io.FileKeyKeeper;
import org.eclipse.passage.lic.internal.emf.EObjectFromBytes;

final class Pack {
    private final Path license;
    private final Path key;

    Pack(Path license, Path key) {
        this.license = license;
        this.key = key;
    }

    Resolved resolve() throws LicensingException {
        return new Resolved();
    }

    Path[] content() {
        return new Path[]{this.license, this.key};
    }

    public String toString() {
        return String.format("pack license=[%s], key=[%s]", this.license.toAbsolutePath(), this.key.toAbsolutePath());
    }

    final class Resolved {
        private final FloatingLicensePack content = this.read(this.decoded());

        Resolved() throws LicensingException {
        }

        private FloatingLicensePack read(byte[] bytes) throws LicensingException {
            return (FloatingLicensePack)new EObjectFromBytes(bytes, FloatingLicensePack.class).get(Collections.singletonMap("floating", FloatingPackage.eINSTANCE));
        }

        private byte[] decoded() throws LicensingException {
            return (byte[])new FlsGearAwre().withGear(g -> Optional.of(this.decoded((FlsGear)g))).orElseThrow(() -> new LicensingException("Fail resolving gear"));
        }

        private final byte[] decoded(FlsGear gear) {
            try {
                return new DecodedContent(Pack.this.license, (KeyKeeper)new FileKeyKeeper(Pack.this.key), gear.codec((LicensedProduct)new InvalidLicensedProduct())).get();
            }
            catch (LicensingException e) {
                e.printStackTrace();
                return new byte[0];
            }
        }

        LicensedProduct product() {
            ProductRef ref = this.content.getLicense().getProduct();
            return new BaseLicensedProduct(ref.getProduct(), ref.getVersion());
        }
    }
}

