/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base.mine;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.passage.lbc.internal.base.i18n.BaseMessages;
import org.eclipse.passage.lbc.internal.base.mine.AssembledConditions;
import org.eclipse.passage.lic.floating.model.api.FloatingLicensePack;
import org.eclipse.passage.lic.floating.model.api.ProductRef;
import org.eclipse.passage.lic.floating.model.meta.FloatingPackage;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.conditions.Condition;
import org.eclipse.passage.lic.internal.api.conditions.ConditionMiningTarget;
import org.eclipse.passage.lic.internal.api.conditions.ConditionOrigin;
import org.eclipse.passage.lic.internal.api.conditions.ConditionPack;
import org.eclipse.passage.lic.internal.api.conditions.mining.ConditionTransport;
import org.eclipse.passage.lic.internal.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.internal.api.diagnostic.Trouble;
import org.eclipse.passage.lic.internal.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.internal.api.io.KeyKeeper;
import org.eclipse.passage.lic.internal.api.io.StreamCodec;
import org.eclipse.passage.lic.internal.base.BaseLicensedProduct;
import org.eclipse.passage.lic.internal.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.internal.base.conditions.BaseConditionOrigin;
import org.eclipse.passage.lic.internal.base.conditions.BaseConditionPack;
import org.eclipse.passage.lic.internal.base.conditions.mining.ArmedMiningTool;
import org.eclipse.passage.lic.internal.base.diagnostic.BaseDiagnostic;
import org.eclipse.passage.lic.internal.base.diagnostic.code.ServiceFailedOnMorsel;
import org.eclipse.passage.lic.internal.emf.EObjectFromBytes;

final class ReassemblingMiningTool
extends ArmedMiningTool {
    private final String user;
    private final LicensedProduct product;
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());

    ReassemblingMiningTool(KeyKeeper key, StreamCodec codec, ConditionTransport transport, LicensedProduct product, String user, ConditionMiningTarget miner) {
        super(key, codec, transport, miner);
        this.product = product;
        this.user = user;
    }

    public ServiceInvocationResult<Collection<ConditionPack>> mine(Collection<Path> sources) {
        ArrayList<ConditionPack> packs = new ArrayList<ConditionPack>();
        ArrayList<Trouble> failures = new ArrayList<Trouble>();
        for (Path license : sources) {
            try {
                packs.add(this.conditions(license));
            }
            catch (LicensingException e) {
                this.log.error("failed: ", (Throwable)e);
                failures.add(new Trouble((TroubleCode)new ServiceFailedOnMorsel(), String.format(BaseMessages.ReassemblingMiningTool_path_failed, license.toAbsolutePath().toString()), (Exception)((Object)e)));
            }
        }
        return new BaseServiceInvocationResult((Diagnostic)new BaseDiagnostic(Collections.emptyList(), failures), packs);
    }

    private ConditionPack conditions(Path license) throws LicensingException {
        FloatingLicensePack pack = this.pack(license);
        if (!this.productFits(pack.getLicense().getProduct())) {
            return this.noConditions(license);
        }
        Collection<Condition> conditions = new AssembledConditions(pack).forUser(this.user);
        return new BaseConditionPack((ConditionOrigin)this.origin(license), conditions);
    }

    private boolean productFits(ProductRef ref) {
        return new BaseLicensedProduct(ref.getProduct(), ref.getVersion()).equals((Object)this.product);
    }

    private FloatingLicensePack pack(Path source) throws LicensingException {
        return (FloatingLicensePack)new EObjectFromBytes(this.decoded(source), FloatingLicensePack.class).get(Collections.singletonMap("floating", FloatingPackage.eINSTANCE));
    }

    private BaseConditionPack noConditions(Path license) {
        return new BaseConditionPack((ConditionOrigin)this.origin(license), Collections.emptyList());
    }

    private BaseConditionOrigin origin(Path license) {
        return new BaseConditionOrigin(this.miner, license.toAbsolutePath().toString());
    }
}

