/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.container;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.osgi.container.ModuleCapability;
import org.eclipse.osgi.container.ModuleRequirement;
import org.eclipse.osgi.container.ModuleWire;

public class NamespaceList<E> {
    public static final Function<ModuleWire, String> WIRE = wire -> wire.getCapability().getNamespace();
    public static final Function<ModuleCapability, String> CAPABILITY = ModuleCapability::getNamespace;
    public static final Function<ModuleRequirement, String> REQUIREMENT = ModuleRequirement::getNamespace;
    private final List<E> elements;
    private final Map<String, List<E>> namespaces;

    public NamespaceList(List<E> elements, Function<E, String> getNamespace) {
        List<E> unmodifiableElements = Collections.unmodifiableList(elements);
        LinkedHashMap<String, List<E>> tmpNamespaces = new LinkedHashMap<String, List<E>>(5);
        int size = unmodifiableElements.size();
        int currentStart = 0;
        String current = null;
        boolean consolidated = false;
        int i = 0;
        while (i < size) {
            String namespace = getNamespace.apply(unmodifiableElements.get(i));
            if (current == null) {
                current = namespace;
            }
            if (!current.equals(namespace)) {
                int currentEnd = i;
                consolidated |= this.addNamespaceList(tmpNamespaces, unmodifiableElements, current, currentStart, currentEnd);
                current = namespace;
                currentStart = i;
            }
            ++i;
        }
        if (size > 0) {
            consolidated |= this.addNamespaceList(tmpNamespaces, unmodifiableElements, current, currentStart, size);
        }
        if (consolidated) {
            ArrayList tmpElements = new ArrayList(size);
            for (Map.Entry e : tmpNamespaces.entrySet()) {
                tmpElements.addAll((Collection)e.getValue());
            }
            this.elements = Collections.unmodifiableList(tmpElements);
        } else {
            this.elements = unmodifiableElements;
        }
        this.namespaces = Collections.unmodifiableMap(tmpNamespaces);
    }

    private boolean addNamespaceList(Map<String, List<E>> tmpNamespaces, List<E> unmodifiableElements, String namespace, int start, int end) {
        List<E> namespaceList = unmodifiableElements.subList(start, end);
        List<E> existing = tmpNamespaces.get(namespace);
        boolean consolidated = false;
        if (existing != null) {
            ArrayList<E> consolidateList = new ArrayList<E>(existing);
            consolidateList.addAll(namespaceList);
            namespaceList = Collections.unmodifiableList(consolidateList);
            consolidated = true;
        }
        tmpNamespaces.put(namespace, namespaceList);
        return consolidated;
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public List<E> getList(String namespace) {
        if (namespace == null) {
            return this.elements;
        }
        return this.namespaces.getOrDefault(namespace, Collections.emptyList());
    }

    public Map.Entry<Integer, Integer> getNamespaceIndex(String namespace) {
        int startIndex = 0;
        for (Map.Entry<String, List<E>> entry : this.namespaces.entrySet()) {
            if (entry.getKey().equals(namespace)) {
                int end = startIndex + entry.getValue().size();
                return new AbstractMap.SimpleEntry<Integer, Integer>(startIndex, end);
            }
            startIndex += entry.getValue().size();
        }
        return null;
    }

    public List<E> copyList() {
        return new ArrayList<E>(this.elements);
    }
}

